// *********************************************************************************************************************
// * 02 Figure 1

// * Percentage differences across the city border over time. 

// * This files looks for trends in the data that suggest or show an LTT effect.

// This files need the following global variables
// - $path_data
// - $path_graph
// - $sample_number
// - $prop_type
// - $crisis_removed
// - $crisis_start
// - $crisis_end
// - $date_final
// - $format_plot
// - $path_results

// *********************************************************************************************************************

// *Notes:

// *  Date  legend
// 2011-02 = end 613
// 2011-08 = end 619
// 2012-02 = end 625
// 2012-08 = end 631
// 2013-02 = end 637
// 2013-08 = end 643
// 2014-02 = end 649
// 2014-08 = end 655
// 2015-02 = end 661

// *********************************************************************************************************************
// * Set up

cap log close  
log using "$path_logs/02_figure1.log", replace

// Community_18M_distance data

use "$path_data/Community_18M_distance.dta", clear


local namebase = "figure1" // base_trend

local sample = "$sample_number" // global : sample_number // default "sample3"

// * time trend on 
// local city_time_trend = $city_tt // 1 for time trend on, 0 for time trend off

// * market segment
local market_segment = 0 // 1 if market segment on, 0 if market segment off

local property_type = $prop_type // number categorical variable from 1 to 5, after 6 or more is combined. 

local ivar = "com"

local cluster_list = "com"
// local cluster = "vce(robust)" // "vce(cluster cluster_group )" //vce(robust)  cluster(com)
local cluster = "vce(robust)" // "vce(cluster cluster_group )" //vce(robust)  cluster(com)

local format_plot = "pdf"

local date_cut = ym(2008,02)
local date_final = $date_final

local add = "_end`date_final'" // textend name x

local crisis_removed = $crisis_removed

local crisis_start = "$crisis_start" // "ym(2008,12)"
local crisis_end = "$crisis_end" //"ym(2009,12)"



// ***********************************************************************************************************

// local filename = "`filename'_`sample'`add'"

// ***********************************************************************************************************

local list_vars = "leasesales pricerent BTO BTR sales_listings"

gen leasesales = TotalLease_LeaseCount/Total_SaleCount
gen pricerent = Total_PRRatio_Avg
gen BTO = BTO_SaleCount
gen BTR = BTR_SaleCount
gen sales_listings = Total_SaleCount/Tot_NewListings


foreach var of varlist `list_vars' {
	gen ln_`var' = log(`var')
}


// *********************************************************************************************************************
// * sample

keep if sample6==1 // until 2018 


// *********************************************************************************************************************

local date_cut_1 = `date_cut'
local date_cut_2 = `date_cut'

if `crisis_removed'==1{

    // % remove crisis period
    local date_cut_1 = `crisis_start'
    local date_cut_2 = `crisis_end'

    local add = "`add'_crisis1_start`crisis_start'_end`crisis_end'"
}
if `crisis_removed'==2{
//  change date cut 1 and 2 
    local date_cut_1 = `crisis_start'
    local date_cut_2 = `crisis_end'

    local add = "`add'_crisis2_start`crisis_start'_end`crisis_end'"

}

sum yearmonth

local min = r(min)
local max = r(max)

// *********************************************************************************************************************
// * leasesales
preserve

    if `crisis_removed'==1{

        drop if yearmonth>=`crisis_start' & yearmonth<=`crisis_end'
    }

    local var = "ln_leasesales"

    qui reghdfe `var' i.yearmonth#1.toronto if abs(distance)<5000, absorb( i.month#i.PropertyType  i.com#i.PropertyType) 

    mat A = J(`max' - `min' + 1, 2,.)
    
    local i = 1
    forvalues d = `min'/`max' {

        if `d'>=`date_cut_1' & `d'<=`date_cut_2' & `crisis_removed'==1 {
            continue
        }

        mat A[`i',1] = `d'
        mat A[`i++',2] = _b[`d'.yearmonth#1.toronto]
    }
    mat coln A = ymcol coeff
    svmat A , names(col)
    format ymcol %tm 


    // * line graph 

    twoway ///
    line  coeff ymcol if ymcol<=`date_cut_1', color(%10) || /// 
    line coeff ymcol if ymcol>`date_cut_2' & ymcol<=`date_final', color(%10) || ///
    lfit  coeff ymcol if ymcol<=`date_cut_1', color(blue)  || ///
    lfit  coeff ymcol if ymcol>`date_cut_2' & ymcol<=`date_final', legend(off) graphregion(fcolor(white)  lcolor(none))   bgcolor(white) plotregion(fcolor(white) lcolor(none)) xtitle("")|| ///
    || ///

    local filename = "`namebase'_`var'_line_final`add'"

    graph export "$path_graph/`filename'.`format_plot'", as(`format_plot') name("Graph") replace


restore

// *********************************************************************************************************************
// * pricerent	

preserve

    if `crisis_removed'==1{

        drop if yearmonth>=`crisis_start' & yearmonth<=`crisis_end'
    }

    local var = "ln_pricerent"

    qui reghdfe `var' i.yearmonth#1.toronto if abs(distance)<5000 & PropertyType == 4, absorb( i.month i.com) 

    mat A = J(`max' - `min' + 1, 2,.)
    
    local i = 1
    forvalues d = `min'/`max' {
        if `d'>=`date_cut_1' & `d'<=`date_cut_2' & `crisis_removed'==1 {
            continue
        }

        mat A[`i',1] = `d'
        mat A[`i++',2] = _b[`d'.yearmonth#1.toronto]
    }
    mat coln A = ymcol coeff

    svmat A , names(col)
    format ymcol %tm 
    
    // * line graph 

    twoway ///
        line coeff ymcol if ymcol<=`date_cut_1', color(%10) || /// 
    line coeff ymcol if ymcol>`date_cut_2' & ymcol<=`date_final', color(%10) || ///
    lfit  coeff ymcol if ymcol<=`date_cut_1', color(blue)  || ///
    lfit  coeff ymcol if ymcol>`date_cut_2' & ymcol<=`date_final', legend(off) graphregion(fcolor(white)  lcolor(none))   bgcolor(white) plotregion(fcolor(white) lcolor(none)) xtitle("")|| ///
    || ///

    local filename = "`namebase'_`var'_line_final`add'"

    graph export "$path_graph/`filename'.`format_plot'", as(`format_plot') name("Graph") replace


restore

// *********************************************************************************************************************
// * BTO

preserve

    if `crisis_removed'==1{

        drop if yearmonth>=`crisis_start' & yearmonth<=`crisis_end'
    }

    local var = "ln_BTO"

    qui reghdfe `var' i.yearmonth#1.toronto if abs(distance)<5000 & PropertyType == 4, absorb(i.month#i.PropertyType  i.com#i.PropertyType)     

    mat A = J(`max' - `min' + 1, 2,.)
    
    local i = 1
    forvalues d = `min'/`max' {
        if `d'>=`date_cut_1' & `d'<=`date_cut_2' & `crisis_removed'==1 {
            continue
        }

        mat A[`i',1] = `d'
        mat A[`i++',2] = _b[`d'.yearmonth#1.toronto]
    }
    mat coln A = ymcol coeff

    svmat A , names(col)
    format ymcol %tm 
    
    // * line graph 

    twoway ///
    line coeff ymcol if ymcol<=`date_cut_1', color(%10) || /// 
    line coeff ymcol if ymcol>`date_cut_2' & ymcol<=`date_final', color(%10) || ///
    lfit  coeff ymcol if ymcol<=`date_cut_1', color(blue)  || ///
    lfit  coeff ymcol if ymcol>`date_cut_2' & ymcol<=`date_final', legend(off) graphregion(fcolor(white)  lcolor(none))   bgcolor(white) plotregion(fcolor(white) lcolor(none)) xtitle("")|| ///
    || ///

    local filename = "`namebase'_`var'_line_final`add'"

    graph export "$path_graph/`filename'.`format_plot'", as(`format_plot') name("Graph") replace


restore

// *********************************************************************************************************************
// * BTR

preserve

    if `crisis_removed'==1{

        drop if yearmonth>=`crisis_start' & yearmonth<=`crisis_end'
    }


    local var = "ln_BTR"

    qui reghdfe `var' i.yearmonth#1.toronto if abs(distance)<10000, absorb(yearmonth) 

    mat A = J(`max' - `min' + 1, 2,.)
    
    local i = 1
    forvalues d = `min'/`max' {
        if `d'>=`date_cut_1' & `d'<=`date_cut_2' & `crisis_removed'==1 {
            continue
        }

        mat A[`i',1] = `d'
        mat A[`i++',2] = _b[`d'.yearmonth#1.toronto]
    }
    mat coln A = ymcol coeff

    svmat A , names(col)
    format ymcol %tm 
    

    // * line graph 

    twoway ///
        line coeff ymcol if ymcol<=`date_cut_1', color(%10) || /// 
    line coeff ymcol if ymcol>`date_cut_2' & ymcol<=`date_final', color(%10) || ///
    lfit  coeff ymcol if ymcol<=`date_cut_1', color(blue)  || ///
    lfit  coeff ymcol if ymcol>`date_cut_2' & ymcol<=`date_final', legend(off) graphregion(fcolor(white)  lcolor(none))   bgcolor(white) plotregion(fcolor(white) lcolor(none)) xtitle("") || ///
    || ///

    local filename = "`namebase'_`var'_line_final`add'"

    graph export "$path_graph/`filename'.`format_plot'", as(`format_plot') name("Graph") replace


restore


// *********************************************************************************************************************

log close