// *****************************************************************************
// * A5: Sales and Leases
// * This file replicates results in Table 1 of the paper.

//  First set global paths running 00_init.do

// Required global variables:
// - $path_data
// - $path_table_reg
// - $sample_number


// *********************************************************************************************************************
cap log close  
log using "$path_logs/07_tableA5_sales_leases.log", replace  

// *****************************************************************************
// * A5: Sales and Leases
// * This file replicates results in Table 1 of the paper for outcomes sales and leases.

use "$path_data/Community_18M_distance.dta", clear


local filename = "tableA5_sales_lease_property_type"
// filename 

local add = ""

local sample = "$sample_number"

local keep = "LTT"

local cluster = "vce(robust)"

local main_indep_vars = "post toronto LTT i.TO_3m"

// about distance thresholds and doughnut hole -> only 5km
local dist = 5000

// *********************************************************************************************************************

local l_ln_Total_SaleCount "log(\# Sales)"
local l_ln_TotalLease_LeaseCount "log(\# Leases)"


// *********************************************************************************************************************

local FE = "i.PropertyType##i.year i.toronto##i.PropertyType i.month##i.PropertyType i.com##i.PropertyType " //i.

local control = "c.yearmonth#c.toronto"

local filename = "`filename'_`sample'`add'"

// *********************************************************************************************************************

local append_replace = "replace"

foreach depvar in "ln_Total_SaleCount" "ln_TotalLease_LeaseCount" {
    // Define independent variables


// Column (1): Semi-detached only -> Not in final sample, because only 450 obs, but results are similar. 
local cond = " & (PropertyType==5)"

    qui reghdfe `depvar' `main_indep_vars' `dist_control' `control' if `sample'==1 & abs(distance)<`dist' `cond', a(`FE') `cluster'
    eststo est1
    estadd local row_det "NO":est1
    estadd local row_semi "YES":est1
    estadd local row_condoA "NO":est1
    estadd local row_dist "5KM":est1
    estadd local row_border "YES":est1

    // Column (2): Detached only
    local cond = " & (PropertyType==4)"

    qui reghdfe `depvar' `main_indep_vars' `dist_control' `control' if `sample'==1 & abs(distance)<`dist' `cond', a(`FE') `cluster'
    eststo est2
    estadd local row_det "YES":est2
    estadd local row_semi "NO":est2
    estadd local row_condoA "NO":est2
    estadd local row_dist "5KM":est2
    estadd local row_border "YES":est2

    // Column (3): Detached and Condo Apt
    local cond = " & (PropertyType==2 | PropertyType==4)"

    qui reghdfe `depvar' `main_indep_vars' `dist_control' `control' if `sample'==1 & abs(distance)<`dist' `cond', a(`FE') `cluster'
    eststo est3
    estadd local row_det "YES":est3
    estadd local row_semi "NO":est3
    estadd local row_condoA "YES":est3
    estadd local row_dist "5KM":est3
    estadd local row_border "YES":est3

    // Column (4): Detached, Semi-detached, and Condo Apt
    local cond = " & (PropertyType==2 | PropertyType==4 | PropertyType==5)"

    qui reghdfe `depvar' `main_indep_vars' `dist_control' `control' if `sample'==1 & abs(distance)<`dist' `cond', a(`FE') `cluster'
    eststo est4
    estadd local row_det "YES":est4
    estadd local row_semi "YES":est4
    estadd local row_condoA "YES":est4
    estadd local row_dist "5KM":est4
    estadd local row_border "YES":est4

    label variable LTT "`l_`depvar''"

    // Export the regression table
    esttab est2 est3 est4 using "$path_table_reg/`filename'.tex", `append_replace' ///
        title("Sales and Lease by Property Type Analysis") nogaps ///
        keep(`keep') drop(LTT_distance,relax) ///
        se star(* 0.1 ** 0.05 *** 0.001) ///
        nonumbers nomtitles nonotes ///
        label 

    local append_replace = "append"

}

log close