


// *********************************************************************************************************************
// * Table A.6: Price and Time-on-the-market regressions

// * This file replicates results of Table A.6 in the paper.

//  First: set global paths running init.do
//  Second: run global set up variables in 01_run.do

// Required global variables:
// - $path_data
// - $path_table_reg
// - $sample_number
// - $market_seg
// - $prop_type
// - $crisis_removed
// - $default_distances
// - $yearmonthfe
// - $houseprice_tier


// Required files:
// - GTA_CLEAN_2000_2018_distance.dta

//*********************************************************************************************************************
// * Notes:
// Sample definitions: 
// - sample2 is the sample for the main results (Jan 2007 to Feb 2009)
// - sample3 is the main sample for the paper (Jan 2006 to Feb 2012)
// - sample31 is the sample for the robustness checks (Jan 2006 to Feb 2011)
// - sample32 is the sample for the robustness checks (Jan 2006 to Feb 2013)
// - sample4 is the sample for the robustness checks (Jan 2006 to Feb 2010)
// - sample5 is the sample for the extended analysis (Jan 2006 to Feb 2014)
// - sample6 is the sample for the extended analysis (Jan 2006 to Feb 2018)
// - sample8 is the sample for the extended analysis (Jan 2006 to Feb 2016)


// ********************************************************************************************************************
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// ********************************************************************************************************************

// ********************************************************************************************************************
// * Transaction level variables
// ********************************************************************************************************************
if $dominant_log==0{
    cap log close  
    log using "$path_logs/08_tableA6_pdom.log", replace
}
// ********************************************************************************************************************
// * Table A.6: Price and Time-on-the-market regressions and Robustness checks 
// * Transaction level variables
// use already clened data

// restart file naming
local filename = "tableA6_pdom"

use "$path_data/GTA_CLEAN_2000_2018_distance.dta", clear


local add = ""

local sample = "$sample_number" // global : sample_number // default "sample3"

local keep = "LTT"

local main_indep_vars = "post toronto LTT i.TO_3m"

local market_segment = $market_seg // 1 if market segment on (main reg in paper), 0 if market segment off by property type
// local market_segment = 0 

local property_type = $prop_type  // from 1 to 6 $prop_type

// * crisis
local crisis_remove = $crisis_removed // 1 to remove crisis period

local count_rows = 0 // count rows whoch outcomes in table

// about distance thresholds and doughnut hole
local default_distances = $default_distances

local placebo_border = $placebo_border

// * crisis

local crisis_start = "$crisis_start" // "ym(2008,12)"
local crisis_end = "$crisis_end" //"ym(2009,12)"

local yearmonthfe = $yearmonthfe

local houseprice_tier = $houseprice_tier

// ********************************************************************************************************************

di "Running Price and Time-on-the-market regressions, Table A6"
di "Sample: `sample'"
di "Property type: `property_type'"
di "Crisis removed: `crisis_remove'"
di "Placebo border: `placebo_border'"
di "Default distances: `default_distances'"
di "Yearmonth FE: `yearmonthfe'"


// *********************************************************************************************************************
// * Set up data

// Sales price
gen lnsold = log(sold_)

// Listing price
gen lnlist = log(asked_)

local var_price = "sold_"

gen sample2 = 1*(yearmonth>=ym(2007,01) & yearmonth<=ym(2009,02))
gen sample31 = 1*(yearmonth>=ym(2006,01) & yearmonth<=ym(2011,02))
gen sample32 = 1*(yearmonth>=ym(2006,01) & yearmonth<=ym(2013,02))
gen sample5=1*(yearmonth>=ym(2006,01) & yearmonth<=ym(2014,02))
gen sample7=1*(yearmonth>=ym(2006,01) & yearmonth<=ym(2008,08))
gen sample8=1*(yearmonth>=ym(2006,01) & yearmonth<=ym(2016,02))

// *********************************************************************************************************************
// * Create categories for X variables

// create categories by bedroom number : 0 1 2 3 4 5 6+
// number of categories: 6
gen X_beds_cat = X_beds
replace X_beds_cat = 6 if X_beds>=6

// create categories by bathroom number : 0 1 2 3 4 5 6+
// number of categories: 6
gen X_baths_cat = X_baths
replace X_baths_cat = 6 if X_baths>=6

// create categories by rooms : 0 1 2 3 4 5 6 7 8 9 10 11-12 13-15 16+
// number of categories: 14
gen X_rooms_cat = X_rooms
replace X_rooms_cat = 11 if X_rooms>=11
replace X_rooms_cat = 13 if X_rooms>=13
replace X_rooms_cat = 16 if X_rooms>=16

// create categories by kitchen : 0 1 2 3+
// number of categories: 4
gen X_kitch_cat = X_kitch
replace X_kitch_cat = 3 if X_kitch>=3

// X_lot: devide in 10 categories by percentiles
// number of categories: 10 (there is a big category with 0 value here)
// egen X_lot_cat = cut(X_lot), group(10)
xtile X_lot_cat = X_lot, nq(13)
// *********************************************************************************************************************
// * Robustness checks

// * crisis

// crisis setup same as above

if `crisis_remove'==1 {
    gen crisis_def= 1*(yearmonth>=`crisis_start' & yearmonth<=`crisis_end')
    local add = "`add'_crisis_start`crisis_start'_end`crisis_end'" 

    drop if crisis_def==1
}

// * property types

//same as above //TODO: Property Types are different in diff data sets, create dictionary
local cond_ = ""
if  `market_segment'<=-1 & `crisis_remove'!= 1   {

    // keep if PropertyType==`property_type'
    local cond_ = "& PropertyType==`property_type'"
    
    if  11==`property_type'{ // DETACHED + SEMI DETACHED
        local cond_ = "& (PropertyType==8 | PropertyType==9)"
    }

    local add = "`add'_prop`property_type'"  
}

if `placebo_border'<0 {

    di "Placebo border: `placebo_border'"

    local add = "`add'_placebo`placebo_border'"  

    sum distance 

    replace distance = distance - `placebo_border'

    gen placebo_tor_def = 1*(distance<0)
    gen LTT_placebo = LTT*(distance<0)
    sum distance placebo_tor_def LTT_placebo 

    drop if toronto==0

    replace toronto = placebo_tor_def
    replace LTT = LTT_placebo
    replace x_25 = (distance<-2500 & distance>-5000)

    drop placebo_tor_def LTT_placebo
}

// * By median price
local cond_hp = ""
local cond_hp_3km = ""
local cond_hp_5km = ""

if `houseprice_tier'>0 {
    egen median_price_3km = median(`var_price') if abs(distance)<`min_dist' & `sample'==1 `cond', by(year)
    egen median_price_5k = median(`var_price') if abs(distance)<`med_dist' & `sample'==1 `cond', by(year)
    egen median_price = median(`var_price') if `sample'==1 `cond', by(year)
}

// * above price
if `houseprice_tier'==1 {
    local add = "`add'_hpabove"  
    local cond_hp_3km = "& `var_price'>median_price_3km"
    local cond_hp_5k = "& `var_price'>median_price_5k"
    local cond_hp = "& `var_price'>median_price"
}
// * below price
if `houseprice_tier'==2 {
    local add = "`add'_hpbelow"  
    local cond_hp = "& `var_price'<=median_price`dist'"
    local cond_hp_3km = "& `var_price'<=median_price_3km"
    local cond_hp_5k = "& `var_price'<=median_price_5k"
    local cond_hp = "& `var_price'<=median_price"
}


// * controls - robustness 

local FE = "i.toronto##i.PropertyType i.month#i.PropertyType i.com#i.PropertyType i.year#i.PropertyType  i.PropertyType#X_heating i.PropertyType#X_basement i.PropertyType#X_family i.PropertyType#X_fire i.PropertyType#X_beds_cat i.PropertyType#X_rooms_cat i.PropertyType#X_kitch_cat i.PropertyType#X_rooms_cat i.PropertyType#X_lot_cat" // used not to be categorical
local control = "c.toronto#c.yearmonth"

if abs(`market_segment')==1{ 
		local FE = "PropertyType i.toronto#i.PropertyType i.month#i.PropertyType i.com#i.PropertyType i.PropertyType#X_heating i.PropertyType#X_basement i.PropertyType#X_family i.PropertyType#X_fire i.PropertyType#X_beds i.PropertyType#X_rooms i.PropertyType#X_kitch i.PropertyType#X_lot" 
local control = "c.toronto#c.yearmonth" 
}

if abs(`market_segment')==2{ 
    // weaker controls
    local control = "c.toronto#c.yearmonth X_heating X_basement X_family X_fire X_beds X_baths X_kitch X_rooms X_lot"  
    local FE = "i.month##i.PropertyType i.com##i.PropertyType"
}

if abs(`market_segment')==3{ /
    // weaker controls
    local control = "c.yearmonth c.toronto#c.yearmonth X_heating X_basement X_family X_fire X_beds X_baths X_kitch X_rooms X_lot"
    local FE = "i.month##i.PropertyType i.com##i.PropertyType"
}

if `yearmonthfe'==1 {
    di "Yearmonth FE!!!!!!!"
    local FE = "`FE' i.yearmonth" //i.  
    // local add = "`add'_feym"
}

di "FE `FE'"

if `default_distances'==1 {
    local min_dist = 3000 // typically 3 km
    local min_label = "3KM"

    local med_dist = 5000
    local med_label = "5KM"

    local doughnut_lab = "2KM"
    local doughnut_dist = 2000

    local add = "`add'_dist1"

}
if `default_distances'==2 {
    // for placebo test uses 2km, 4km, donut 1km
    local min_dist = 6000
    local min_label = "6KM"

    local med_dist = 8000
    local med_label = "8KM"

    local doughnut_lab = "2KM"
    local doughnut_dist = 2000

    local add = "`add'_dist2"

}
if `default_distances'==0 {
    // for placebo test uses 2km, 4km, donut 1km
    local min_dist = 2000
    local min_label = "2KM"

    local med_dist = 4000
    local med_label = "4KM"

    local doughnut_lab = "1KM"
    local doughnut_dist = 1000

    local add = "`add'_dist0"
}
local filename = "`filename'_`sample'`add'"

// ********************************************************************************************************************
// * Time-on-the-market
// ********************************************************************************************************************

local cond =" & prev_owner_time_to_move>1080"
local cond = "`cond' `cond_'"

label variable LTT "Time-on-the-market"

local depvar = "lndom"

eststo clear

if `houseprice_tier'>0 {

    local c2 = "& `depvar'!=."
//     drop median_price_3km median_price_5k median_price
    egen median_price_3km = median(`var_price') if abs(distance)<`min_dist' & `sample'==1 `cond' `c2', by(year)
    egen median_price_5k = median(`var_price') if abs(distance)<`med_dist' & `sample'==1 `cond' `c2', by(year)
    egen median_price = median(`var_price') if `sample'==1 `cond' `c2', by(year)
}

// * regs

if `crisis_remove'==0 {
qui reghdfe `depvar' `main_indep_vars' `control' if `sample'==1 & abs(distance)<`min_dist' `cond' `cond_hp_3km' , a(`FE') vce(cluster community)
eststo est2
estadd local row_dist "`min_label'":est2
estadd local row_TO_3m "YES":est2
estadd local row_time_trend "YES":est2
}


qui reghdfe `depvar' `main_indep_vars' x_25 `control' if `sample'==1 & abs(distance)<`med_dist' `cond' `cond_hp_5km' , a(`FE') vce(cluster community)
eststo est5
estadd local row_dist "`med_label'":est5
estadd local row_TO_3m "YES":est5
estadd local row_dist_trend "Step":est5
estadd local row_time_trend "YES":est5

qui reghdfe `depvar' `main_indep_vars' x_25 `control' if `sample'==1 & abs(distance)<`med_dist' & abs(distance)>=`doughnut_dist' `cond' `cond_hp_5km' , a(`FE') vce(cluster community)
eststo est6
estadd local row_dist "`med_label'":est6
estadd local row_TO_3m "YES":est6
estadd local row_dist_trend "Step":est6
estadd local row_time_trend "YES":est6
estadd local row_donut "`doughnut_lab'":est6

if `crisis_remove'==0 {
    if `placebo_border'==0 {
        qui reghdfe `depvar' `main_indep_vars' LTT_distance `control' if `sample'==1 `cond' `cond_hp', a(`FE') vce(cluster community)
        eststo est8
        estadd local row_dist "ALL":est8
        estadd local row_TO_3m "YES":est8
        estadd local row_time_trend "YES":est8
    }
    else {
        // assume 5km distance
        qui reghdfe `depvar' `main_indep_vars' `control' x_25 if `sample'==1 & abs(distance)<5000 `cond' `cond_hp', a(`FE') `cluster' 
        eststo est8
        estadd local row_dist "5KM":est8
        estadd local row_TO_3m "YES":est8
        estadd local row_time_trend "YES":est8
        estadd local row_dist_trend "Step":est8
    }
}

if `count_rows'==0 {
    local replace_append = "replace"
}
else {
    local replace_append = "append"
}

local count_rows = `count_rows' + 1

esttab using "$path_table_reg/`filename'.tex", nogaps se star(* 0.1 ** 0.05 *** 0.001) nonumbers nomtitles nonotes keep(`keep')  label `replace_append' 


// ********************************************************************************************************************
// * Price
// ********************************************************************************************************************

local FE = "i.toronto##i.PropertyType i.month#i.PropertyType i.com#i.PropertyType i.year#i.PropertyType  i.PropertyType#X_heating i.PropertyType#X_basement i.PropertyType#X_family i.PropertyType#X_fire i.PropertyType#X_beds_cat i.PropertyType#X_rooms_cat i.PropertyType#X_kitch_cat i.PropertyType#X_rooms_cat i.PropertyType#X_lot_cat" 

label variable LTT "Sales price"

local depvar = "lnsold"

eststo clear

if `houseprice_tier'>0 {

    local c2 = "& `depvar'!=."

    drop median_price_3km median_price_5k median_price
    egen median_price_3km = median(`var_price') if abs(distance)<`min_dist' & `sample'==1 `cond' `c2', by(year)
    egen median_price_5k = median(`var_price') if abs(distance)<`med_dist' & `sample'==1 `cond' `c2', by(year)
    egen median_price = median(`var_price') if `sample'==1 `cond' `c2', by(year)
}

if `crisis_remove'==0 {
qui reghdfe `depvar' `main_indep_vars' `control' if `sample'==1 & abs(distance)<`min_dist' `cond' `cond_hp_3km', a(`FE') vce(cluster community)
eststo est2
estadd local row_dist "`min_label'":est2
estadd local row_TO_3m "YES":est2
estadd local row_time_trend "YES":est2
}

qui reghdfe `depvar' `main_indep_vars' x_25 `control' if `sample'==1 & abs(distance)<`med_dist' `cond' `cond_hp_5km', a(`FE') vce(cluster community)
eststo est5
estadd local row_dist "`med_label'":est5
estadd local row_TO_3m "YES":est5
estadd local row_dist_trend "Step":est5
estadd local row_time_trend "YES":est5

qui reghdfe `depvar' `main_indep_vars' x_25 `control' if `sample'==1 & abs(distance)<`med_dist' & abs(distance)>=`doughnut_dist' `cond' `cond_hp_5km', a(`FE') vce(cluster community)
eststo est6
estadd local row_dist "`med_label'":est6
estadd local row_TO_3m "YES":est6
estadd local row_dist_trend "Step":est6
estadd local row_time_trend "YES":est6
estadd local row_donut "`doughnut_lab'":est6

if `crisis_remove'==0 {
    if `placebo_border'==0 {
        qui reghdfe `depvar' `main_indep_vars' LTT_distance `control' if `sample'==1 `cond' `cond_hp', a(`FE') vce(cluster community)
        eststo est8
        estadd local row_dist "ALL":est8
        estadd local row_TO_3m "YES":est8
        estadd local row_time_trend "YES":est8
    }
    else {
        // assume 5km distance
        qui reghdfe `depvar' `main_indep_vars' `control' x_25 if `sample'==1 & abs(distance)<5000 `cond' `cond_hp', a(`FE') vce(cluster community)
        eststo est8
        estadd local row_dist "5KM":est8
        estadd local row_TO_3m "YES":est8
        estadd local row_time_trend "YES":est8
        estadd local row_dist_trend "Step":est8
    }
}

if `count_rows'==0 {
    local replace_append = "replace"
}
else {
    local replace_append = "append"
}
local count_rows = `count_rows' + 1

esttab using "$path_table_reg/`filename'.tex", nogaps se star(* 0.1 ** 0.05 *** 0.001) nonumbers nomtitles nonotes keep(`keep')  label `replace_append' ///
			scalars("row_dist Distance threshold" "row_TO_3m Indicators TO +-3 m." "row_time_trend City time trend" "row_dist_trend Distance LTT trends"  "row_donut Donut Hole" ) 	



// ********************************************************************************************************************



if $dominant_log==0{
    log close
}