// *********************************************************************************************************************
// * Table A.12 Price alternative periods   

// * This file runs  the hazard model for different periods

//  First set global paths running 01_init.do in 00_init
//  Then run this file

// Global variables:
// market_seg: -1 for all segments, 0 for segment 0, 1 for segment 1, 2 for segment 2, -2 for all segments except 2
// prop_type: 1 to 15 for property types, after 6 combinations, see file 01_basic_regs/01_replic_main_table_seg.do
// placebo_border: 0 for no placebo, -2000, -3000, -4000, -5000, -6000 for placebo borders
// crisis_removed: 0 for no crisis removed, 1 for crisis removed
// sampl_num: e for main samplee estimation, see other numbers in 01_basic_regs/01_replic_main_table_seg.do
// default_distances: 0 for default distances, 1 for extended distances thresholds, defined in 01_basic_regs/06_replic_main_table_seg_dist.do
// yearmonthfe: 0 for no yearmonth fixed effects, 1 for yearmonth fixed effects
// crisis_start: crisis start date
// crisis_end: crisis end date

// *********************************************************************************************************************

global dominant_log = 1
cap log close  
log using "$path_logs/14_tableA12_price_period.log", replace

// *********************************************************************************************************************
// * Table A.12 Price alternative periods  and segment markets.

global market_seg = 0 
global placebo_border = "0"
global crisis_removed = 0
global default_distances = 1 
global yearmonthfe = 0 //
global houseprice_tier = 0 // 0 for all, 1 for above median, 2 for below median
global dom_on = 0

// *********************************************************************************************************************

use "$path_data/Community_18M_distance.dta", clear

gen lnprice = log(Total_AvgSP)


local keep = "LTT"
local cluster = "vce(robust)"
local main_indep_vars = "post toronto LTT i.TO_3m"
local FE = "i.PropertyType##i.year i.toronto##i.PropertyType i.month##i.PropertyType i.com##i.PropertyType " //i.
local control = "" //c.yearmonth#c.toronto
local cond = ""

local l_lnprice = "log (Price)"


local min_dist = 3000 
local min_label = "3KM"

local med_dist = 5000
local med_dist_lab = "5KM"

local doughnut_lab = "2KM"
local doughnut_dist = 2000

local samples = "4 6"


foreach s in `samples'{

    eststo clear

    di "Sample `s'"
    
    local sample = "sample`s'"

    local filename = "tableA12_lnprice_segment_sample`s'"
    local depvar = "lnprice"

    qui reghdfe `depvar' `main_indep_vars' `control' if `sample'==1 & abs(distance)<`min_dist' `cond'  , a(`FE') `cluster'
    eststo est2
    estadd local row_dist "`min_label'":est2
    estadd local row_TO_3m "YES":est2
    estadd local row_time_trend "YES":est2

    qui reghdfe `depvar' `main_indep_vars' x_25 `control' if `sample'==1 & abs(distance)<`med_dist' `cond' , a(`FE') `cluster'
    eststo est5
    estadd local row_dist "`med_dist_lab'":est5
    estadd local row_TO_3m "YES":est5
    estadd local row_dist_trend "Step":est5
    estadd local row_time_trend "YES":est5

    qui reghdfe `depvar' `main_indep_vars' x_25 `control' if `sample'==1 & abs(distance)<`med_dist' & abs(distance)>=2000 `cond' `cond_hp_5km', a(`FE') `cluster'
    eststo est6
    estadd local row_dist "`med_dist_lab'":est6
    estadd local row_TO_3m "YES":est6
    estadd local row_dist_trend "Step":est6
    estadd local row_time_trend "YES":est6
    estadd local row_donut "`doughnut_lab'":est6

    qui reghdfe `depvar' `main_indep_vars' LTT_distance `control' if `sample'==1  `cond', a(`FE') `cluster'
    eststo est8
    estadd local row_dist "ALL":est8
    estadd local row_TO_3m "YES":est8
    estadd local row_time_trend "YES":est8
    estadd local row_dist_trend "YES":est8 // changed last row from dist tp row_dist_trend

    label variable LTT "`l_`depvar''"

    esttab using "$path_table_reg/`filename'.tex", nogaps se star(* 0.1 ** 0.05 *** 0.001) nonumbers nomtitles nonotes keep(`keep') drop(LTT_distance,relax) label replace

}

log close
global dominant_log = 0
// *********************************************************************************************************************
