% Produce further results table

% Variables to include in results table
vars = {'Tmhinv'   'Moving rate of owners       ';
        'SSh'      'Buy-to-own (BTO) sales      ';
        'SSi'      'Buy-to-rent (BTR) sales     ';
        'SSo'      'Total sales                 ';
        'Tso'      'Time-to-sell                ';
        'SSlo'     'Leases-to-sales ratio       ';
        'pr'       'Price-to-rent ratio         ';
        'PP'       'Average transactions price  ';
        'h'        'Homeownership rate          ';
        'n'        'City population             ';
        'GG'       'Tax revenue                 '};

% Change to tax rates
taxnew = [0.0285;0.0285];

% Number of years to average over
yrs = 4;

% Loop over different calibrations
for c=1:3

    % Get targets and calibrate parameters
    tgt = targets();
    if (c == 2)
        tgt.rz = 0.0793;
    end
    if (c == 3)
        tgt.chi = 0.000000001;
    end
    matchregression;
    prm = calibration(tgt);

    % Call Dynare
    dynare rentown.mod;

    % Find number of discrete time periods in one year
    py = round(1/M_.params(find(strcmp(M_.param_names,'ell'))));

    % Extract variable indices
    vnum = size(vars,1);
    vidx = zeros(vnum,1);
    for v=1:vnum
        vidx(v) = find(strcmp(M_.endo_names,vars(v,1)));
    end

    % Get impulse response functions and average
    imprss = oo_.endo_simul(vidx,end)';
    impr = oo_.endo_simul(vidx,1:(1+py*yrs))';
    resp = log(impr(2:end,:)) - ones(py*yrs,1)*log(impr(1,:));
    avresp = mean(resp)';

    % Conversion to percentage points
    avresp = 100*(exp(avresp) - 1);
    hidx = find(strcmp(vars,'h'));
    avresp(hidx) = impr(1,hidx)*avresp(hidx);

    % Display results table
    if (c == 1)
        disp('Baseline:');
    end
    if (c == 2)
        disp('3% gap');
    end
    if (c == 3)
        disp('No mobility');
    end
    fprintf('Variable name                :  Average ');
    for v=1:vnum
        fprintf([vars{v,2} ' :   ' num2str(avresp(v),'%.1f') '%%\n']);
    end

end
