% Plot impulse responses to tax change

% Calibrate model
tgt = targets();
matchregression;
prm = calibration(tgt);

% Variables to show
vplot = {'SSi'      'BTR sales (LHS)     ';
         'SSlo'     'Leases-to-sales ratio (LHS)';
         'h'        'Homeownership rate (RHS)   '};

% Length of period to plot in years, and number of columns
na = 11; % years after
nb = 1; % years before
nd = 30; % days to smooth over

% Formatting of impulse responses
xlab = 'Years';
ylab = '%';

% Call Dynare
dynare rentown.mod;

% Generate time axis
py = round(1/M_.params(find(strcmp(M_.param_names,'ell'))));
tidx = (-nb:(1/py):na)';

% Extract variable indices
vnum = size(vplot,1);
vidx = zeros(vnum,1);
for v=1:vnum
    vidx(v) = find(strcmp(M_.endo_names,vplot(v,1)));
end

% Get impulse response functions and pad and truncate appropriately
imprss = oo_.endo_simul(vidx,end)';
impr = oo_.endo_simul(vidx,:)';
impr = impr(1:(1 + py*na),:);
impr = [ones(py*nb,1)*impr(1,:);impr(2:end,:)];
nt = size(impr,1);

% Log-point changes in variables
resp = [log(impr(:,1:2)) impr(:,3)] - ones(nt,1)*[log(impr(1,1:2)) impr(1,3)];
ssresp = ([log(imprss(1:2)) imprss(3)] - [log(impr(1,1:2)) impr(1,3)])';

% Smoothing daily impulse responses
resps = zeros(nt-nd,vnum);
for t=(py*nb+1):nt-nd
    resps(t,:) = mean(resp(t:t+nd,:));
end
t = tidx(1:size(resps,1));
tshock = tidx(py*nb+1);
tmin = min(t);
tmax = max(t);

% Conversion to percentage points
resps(:,1:2) = exp(resps(:,1:2))-1;
ssresp(1:2) = exp(ssresp(1:2))-1;
resps = 100*resps;
ssresp = 100*ssresp;

% Extract variables for left and right axes
yl = resps(:,1:2);
yr = resps(:,3);
ylss = ssresp(1:2);
yrss = ssresp(3);

% Plot lines
lineclr1 = [0.7490 0.0510 0.1725];
lineclr2 = [0.2157 0.0196 0.6275];
lineclr3 = [0 0.5020 0.2510];
[ha,hgl,hgr] = plotyy(t,yl,t,yr);
set(hgl(1),'Color',lineclr1);
set(hgl(2),'Color',lineclr2);
set(hgr(1),'Color',lineclr3);
set(hgl(1),'LineStyle','-');
set(hgl(2),'LineStyle','-');
set(hgr(1),'LineStyle','-');
set(hgl(1),'LineWidth',2);
set(hgl(2),'LineWidth',2);
set(hgr(1),'LineWidth',2);
hal = ha(1);
har = ha(2);
set(hal,'NextPlot','add');
set(har,'NextPlot','add');
hg = plot(hal,[tshock tmax],[ylss(1) ylss(1)]);
set(hg,'Color',lineclr1);
set(hg,'LineStyle',':');
set(hg,'LineWidth',2);
hg = plot(hal,[tshock tmax],[ylss(2) ylss(2)]);
set(hg,'Color',lineclr2);
set(hg,'LineStyle',':');
set(hg,'LineWidth',2);
hg = plot(har,[tshock tmax],[yrss(1) yrss(1)]);
set(hg,'Color',lineclr3);
set(hg,'LineStyle',':');
set(hg,'LineWidth',2);

% Axis range
ymin = min(0,min(min(yl)));
ymax = max(0,max(max(yl)));
ymin = ymin - 0.05*(ymax - ymin);
ymax = ymax + 0.03*(ymax - ymin);
spacetick = 10;
set(ha,'YTickMode','manual');
YTick = spacetick*ceil(ymin/spacetick):spacetick:spacetick*floor(ymax/spacetick);
set(ha,'YTick',YTick);
set(hal,'XLim',[tmin tmax]);
set(har,'XLim',[tmin tmax]);
set(hal,'YLim',[ymin ymax]);
spacetickr = 0.5;
YTickr = (-(size(YTick,2)-1)*spacetickr:spacetickr:0);
yminr = YTickr(1) - (spacetickr/spacetick)*(YTick(1) - ymin);
ymaxr = YTickr(end) + (spacetickr/spacetick)*(ymax - YTick(end));
set(har,'YLim',[yminr ymaxr]);
set(har,'YTickMode','manual');
set(har,'YTick',YTickr);

% Axis labels
set(get(hal,'XLabel'),'String','Years');
set(get(hal,'YLabel'),'String','%');
set(get(har,'YLabel'),'String','p.p.');

% Add legend
hl = legend([hgl;hgr],vplot(1:3,2));
