function popcred = popcredcost(kappa,prmk)
% Calculate implied population and credit costs

% Implied city population
popcred.n = ( (((prmk.vo*prmk.pih + prmk.rho)*(1-prmk.ps)*prmk.thetao*prmk.uo - prmk.mh*prmk.qh)/kappa) - prmk.xi*prmk.ml*prmk.ql )/prmk.rho;

% Implied credit-cost threshold
popcred.Z = exp(prmk.mu + prmk.sig*norminv(kappa));

% Implied average credit cost conditional on paying it
popcred.Kbar = exp(prmk.mu + ((prmk.sig^2)/2))*normcdf((log(popcred.Z) - prmk.mu - (prmk.sig^2))/prmk.sig)/kappa;

end
