function yl = solverentthres(prm)
% Find the transaction threshold for renters

% Check for existence of a solution
exists = rentthrescrit(prm.zetal,prm);
if (exists < 0)
    yl = NaN;
    return;
end

% Search numerically for a solution
[yl,~,exitflag] = fzero(@rentthrescrit,(prm.lambdal/(prm.lambdal-1))*prm.zetal,[],prm);

% Check return is valid
if (exitflag < 0)
    yl = NaN;
end

end
