% Compute welfare effects of taxes

% Change to tax rates
taxnew = [0.0285;0.0285];
%taxnew = [0.0285;0.057951398749419];

% Get targets and calibrate parameters
tgt = targets();
matchregression;
prm = calibration(tgt);

% Set new tax rates
prm2 = prm;
prm2.tauh = taxnew(1);
prm2.taui = taxnew(2);

% Solve model before and after the tax change
res = predict(prm);
res2 = predict(prm2);

% Increase in tax revenue
TR = res2.GG - res.GG; % Revenue flow
Pi = (res2.PPPi - res.PPPi); % Present value

% Total welfare loss
Omega = res2.Omega - res.Omega;

% Decomposition of terms in welfare function (equation 52)
Omegaqh = (1/prm.r)*(res2.qh - res.qh)*res2.VVh; % Change in qh
Omegaql = (1/prm.r)*(res2.ql - res.ql)*res2.VVl; % Change in ql
OmegaDl = -(1/prm.r)*prm2.Dl*(res2.ql - res.ql); % Change in ql (cont.)
OmegaFi = -(1/prm.r)*prm2.Fi*(res2.bi - res.bi); % Change in bi
OmegaCi = -(1/prm.r)*prm2.Ci*(res2.SSi - res.SSi); % Change in Si
OmegaK = -(1/prm.r)*((prm2.xi*res2.ml*res2.ql + res2.a)*res2.kappa*res2.Kbar - (prm2.xi*res.ml*res.ql + res.a)*res.kappa*res.Kbar); % Change in gamma*Kbar
OmegaE = -(1/prm.r)*prm2.E*(res2.a - res.a); % Change in n
OmegaVVl = (1/prm.r)*(res2.VVl - res.VVl)*res.ql; % Change in Vl
OmegaFl = -(1/prm.r)*prm2.Fl*(res2.bl - res.bl); % Change in bl
OmegaClw = -(1/prm.r)*(prm2.Cw + prm2.Cl)*(res2.SSl - res.SSl); % Change in Sl
OmegaVVh = (1/prm.r)*(res2.VVh - res.VVh)*res.qh; % Change in Vh
OmegaFh = -(1/prm.r)*prm2.Fh*(res2.bh - res.bh); % Change in bh
OmegaCh = -(1/prm.r)*prm2.Ch*(res2.SSh - res.SSh); % Change in Sh
OmegaCo = -(1/prm.r)*prm2.Co*(res2.SSo - res.SSo); % Change in So

% Grouping welfare terms into within and across markets (equation 52)
Wacross = -(Omegaqh + Omegaql + OmegaDl + OmegaFi + OmegaCi + OmegaK); % Across markets
Wwithinl = -(OmegaVVl + OmegaFl + OmegaClw); % Within rental market
Wwithino = -(OmegaVVh + OmegaFh + OmegaCh + OmegaCo); % Within ownership market
Wwithin = Wwithinl + Wwithino; % Total within markets effect
Wpopn = -OmegaE; % Population effect

% Conversion of present value effects to flow consumption equivalents
ceq = 1000*(prm.r + prm.rho);
Cacross = ceq*Wacross;
Cwithinl = ceq*Wwithinl;
Cwithino = ceq*Wwithino;
Cwithin = ceq*Wwithin;
Cpopn = ceq*Wpopn;
Ctotal = Cacross + Cwithin + Cpopn;
CTR = ceq*Pi;

% Welfare losses as percentages of tax revenue
ltotal = 100*Ctotal/CTR;
lacross = 100*Cacross/CTR;
lwithino = 100*Cwithino/CTR;
lwithinl = 100*Cwithinl/CTR;
lwithin = 100*Cwithin/CTR;
lpopn = 100*Cpopn/CTR;

% Decomposition of welfare effect by groups
CH = -ceq*(res2.HH - res.HH);
CBh = -ceq*(res2.BBh - res.BBh);
CUo = -ceq*(res2.UUo - res.UUo);
CW = -ceq*(res2.WW - res.WW);
CBl = -ceq*(res2.BBl - res.BBl);
CL = -ceq*(res2.LL - res.LL);
CUl = -ceq*(res2.UUl - res.UUl);

% Display results
fprintf('\nConsumption-equivalent welfare losses:\n');
fprintf(['Total loss :  ' num2str(Ctotal) '\n']);
fprintf(['Across markets :  ' num2str(Cacross) '\n']);
fprintf(['Within markets :  ' num2str(Cwithin) '\n']);
fprintf(['Within rental market :  ' num2str(Cwithinl) '\n']);
fprintf(['Within ownership market :  ' num2str(Cwithino) '\n']);
fprintf(['Population :  ' num2str(Cpopn) '\n']);
fprintf(['Increase in tax revenue :  ' num2str(CTR) '\n']);

fprintf('\nLosses as fraction of extra tax revenue:\n');
fprintf(['Total loss :  ' num2str(ltotal) '\n']);
fprintf(['Across markets :  ' num2str(lacross) '\n']);
fprintf(['Within markets :  ' num2str(lwithin) '\n']);
fprintf(['Within rental market :  ' num2str(lwithinl) '\n']);
fprintf(['Within ownership market :  ' num2str(lwithino) '\n']);
fprintf(['Population :  ' num2str(lpopn) '\n']);

fprintf('\nWelfare effects on individuals (total thousands of dollars):\n');
fprintf(['Owner occupiers           :  ' num2str(CH) '\n']);
fprintf(['Home-buyers               :  ' num2str(CBh) '\n']);
fprintf(['Sellers                   :  ' num2str(CUo) '\n']);
fprintf(['Tenants                   :  ' num2str(CW) '\n']);
fprintf(['Looking to rent           :  ' num2str(CBl) '\n']);
fprintf(['Landlords with tenants    :  ' num2str(CL) '\n']);
fprintf(['Landlords without tenants :  ' num2str(CUl) '\n']);
fprintf(['Investors                 :  ' num2str(0) '\n']);
fprintf(['New entrants to city      :  ' num2str(0) '\n']);
