// *********************************************************************************************************************
// * Table A.4: Property characteristics and City of Toronto and LTT

// * This file contains the code to generate Table A.4 in the paper.

// * Run on Transaction level variables

// It runs: 
// Regressions of the property characteristics on City of Toronto and LTT, for different distance thresholds and periods.
// The property characteristics are: 
// Heating, Basement, Family, Fire, Bedrooms, Bathrooms, Rooms, Lot

// ********************************************************************************************************************

if $dominant_log==0{
    cap log close  
    log using "$path_logs/06_tableA4_x.log", replace
}

// use already cleaned data
use "$path_data/GTA_CLEAN_2000_2018_distance.dta", clear

// *********************************************************************************************************************
// * Set up data

local sample = "$sample_number"

gen periodPRE = 1*(yearmonth<ym(2008,02))
gen periodALL = 1
gen main_var_PRE = toronto 
gen main_var_ALL = LTT
gen mainvar = toronto

//labels
local labeldom "Time-on-the-market"
local labelsold_ "Sales price"
local labelX_heating "Heating"
local labelX_basement "Basement"
local labelX_family "Family"
local labelX_fire "Fire"
local labelX_beds "Bedrooms"
local labelX_baths "Bathrooms"
local labelX_kitch "Kitchen"
local labelX_rooms "Rooms"
local labelX_lot "Lot"

// *********************************************************************************************************************

local control_PRE = "" // "c.toronto#c.yearmonth"
local control_ALL = "toronto post" // "c.toronto#c.yearmonth i.toronto"
local FE = "year PropertyType month"

// * Define variables and settings
local vars X_heating X_basement X_family X_fire X_beds X_baths X_rooms X_lot
local thresholds 3000 5000
local periods PRE ALL

// equivalent to foreach below, control for other characteristics
local control_X_heating X_basement X_family X_fire X_beds X_baths X_kitch X_rooms X_lot
local control_X_basement X_heating X_family X_fire X_beds X_baths X_kitch X_rooms X_lot
local control_X_family X_heating X_basement X_fire X_beds X_baths X_kitch X_rooms X_lot
local control_X_fire X_heating X_basement X_family X_beds X_baths X_kitch X_rooms X_lot
local control_X_beds X_heating X_basement X_family X_fire X_baths X_kitch X_rooms X_lot
local control_X_baths X_heating X_basement X_family X_fire X_beds X_kitch X_rooms X_lot
local control_X_kitch X_heating X_basement X_family X_fire X_beds X_baths X_rooms X_lot
local control_X_rooms X_heating X_basement X_family X_fire X_beds X_baths X_kitch X_lot
local control_X_lot X_heating X_basement X_family X_fire X_beds X_baths X_kitch X_rooms


sum `vars' 

local append_replace = "replace"
// * Loop through variables, thresholds, and periods
foreach var in `vars' {
    foreach period in `periods' {
        foreach threshold in `thresholds' {
            di "Variable: `var', Threshold: `threshold', Period: `period'"
            
            local threshold_ = `threshold'/1000
            // Define sample conditions
            local samp_dis = "(abs(distance) < `threshold') & (period`period' == 1)"

            // Define dependent variable
            local depvar `var'

            replace mainvar = main_var_`period'
            
            // variable label called dep_Var 
            label variable mainvar `label`depvar''

            local vars_control = "`control_`var''"
            di "Control variables: `vars_control'"

            local control = "`control_`period''"

            * Run regressions for each scenario
            qui reghdfe `depvar' mainvar `control' `vars_control' if `sample' == 1 & `samp_dis', a(`FE') vce(robust)
            eststo est`var'_`threshold'_`period'
            estadd local row_dist "`threshold_'KM":est`var'_`threshold'_`period'
            estadd local row_pre_policy "`period'":est`var'_`threshold'_`period'

            qui esttab est`var'_`threshold'_`period', ///
                nogaps se star(* 0.1 ** 0.05 *** 0.001) ///
                nomtitles /// 
                nonotes drop(const LTT_distance post c.toronto*  yearmonth toronto, relax) label ///
                scalars("row_dist Distance threshold" "row_pre_policy Period") 
        }
    }
    esttab est`var'_* using "$path_table_reg/tableA4_x.tex" , `append_replace' ///
                nogaps se star(* 0.1 ** 0.05 *** 0.001) ///
                nonumbers nomtitles /// 
                nonotes drop(const LTT_distance post c.toronto* yearmonth toronto x_25 `vars_control', relax) label ///
                scalars("row_dist Distance threshold" "row_pre_policy Period") 

    qui esttab est`var'_* , ///
                nogaps se star(* 0.1 ** 0.05 *** 0.001) ///
                nonumbers nomtitles /// 
                nonotes drop(const LTT_distance post c.toronto* x_25  yearmonth toronto `vars_control', relax) label ///
                scalars("row_dist Distance threshold" "row_pre_policy Period")

    local append_replace = "append"

}

// *********************************************************************************************************************

if $dominant_log==0{
    log close
}