// *********************************************************************************************************************
// * Table A.8: Placebo test

// * This file runs the placebo test assuming the border is within City of Toronto at different distances from the border.

//  First set global paths running 01_init.do in 00_init
//  Then run this file

// Global variables:
// market_seg: -1 for all segments, 0 for segment 0, 1 for segment 1, 2 for segment 2, -2 for all segments except 2
// prop_type: 1 to 15 for property types, after 6 combinations, see file 01_basic_regs/01_replic_main_table_seg.do
// placebo_border: 0 for no placebo, -2000, -3000, -4000, -5000, -6000 for placebo borders
// crisis_removed: 0 for no crisis removed, 1 for crisis removed
// sampl_num: e for main samplee estimation, see other numbers in 01_basic_regs/01_replic_main_table_seg.do
// default_distances: 0 for default distances, 1 for extended distances thresholds, defined in 01_basic_regs/06_replic_main_table_seg_dist.do
// yearmonthfe: 0 for no yearmonth fixed effects, 1 for yearmonth fixed effects
// crisis_start: crisis start date
// crisis_end: crisis end date


// *********************************************************************************************************************
// * set up

global dominant_log = 1 // 1 or higher for dominant, 0 for non-dominant
cap log close  
log using "$path_logs/10_tableA8_placebo.log", replace

// *********************************************************************************************************************
// * Table A.8: Placebo test

// * This file runs the placebo test assuming the border is within City of Toronto at different distances from the border.

global market_seg = -2
global prop_type = 4
global placebo_border = "0"
global crisis_removed = 0
global sampl_num= "3"
global sample_number = "sample$sampl_num"
global default_distances = 0 
global yearmonthfe = 0 //
global houseprice_tier = 0 // 0 for all, 1 for above median, 2 for below median
// local nprops = 6



// *********************************************************************************************************************
// * placebo test

local placebo_list = "3000 4000 5000 6000"
foreach i in `placebo_list'{

    global placebo_border = "-`i'" 
    di "Placebo border `i'"
    
    do "$dofiles/03_table1.do"
    
}

di "End of placebo run"
di "*********************************************************************************************************************"

log close
global dominant_log = 0