// ****************************************************************************
// * Table A.9: Robustness checks on BTO and BTR using different sample cutoff 

// This code runs the robustness checks on BTO and BTR using different sample cutoffs (6M, 12M, 24M)

// Run 00_init.do to set the global paths

// Uses global variables:
// - $path_data
// - $path_table_reg

// ****************************************************************************

cap log close
log using "$path_logs/11_tableA9_BTO_BTR.log", replace

// ****************************************************************************
// * Table A.9: Robustness checks on BTO and BTR using different sample cutoff 

// This code runs the robustness checks on BTO and BTR using different sample cutoffs (6M, 12M, 24M)

*--------------------------------
*** Using 6-month cutoff ****
*--------------------------------

clear all
use "$path_data/Community_6M.dta", clear

merge m:1 Area Municipality Community using "$path_data/community_distance.dta"
keep if _m==3

* yearmonth
rename YR YOS
rename Mn MOS
gen yearmonth=ym(YOS,MOS)
format yearmonth %tm

* houses sample
keep if Area=="Toronto" | (Municipality=="Mississauga" | Municipality=="Brampton" | Municipality=="Vaughan" | Municipality=="Richmond Hill" | Municipality=="Markham" | Municipality=="Pickering")

*rename house types
encode HouseType,gen(PropertyType)

** toronto
gen toronto=1*(Area=="Toronto")
gen post=1*(yearmonth>ym(2008,02))
gen LTT=toronto*post
   
** GENERATING +-6 TO DUMMIES
gen TO_3m=1*(toronto==1 & yearmonth==ym(2007,10))
replace TO_3m=2*(toronto==1 & yearmonth==ym(2007,11)) if TO_3m==0
replace TO_3m=3*(toronto==1 & yearmonth==ym(2007,12)) if TO_3m==0
replace TO_3m=4*(toronto==1 & yearmonth==ym(2008,01)) if TO_3m==0
replace TO_3m=5*(toronto==1 & yearmonth==ym(2008,02)) if TO_3m==0
replace TO_3m=6*(toronto==1 & yearmonth==ym(2008,03)) if TO_3m==0

** SAMPLES **
gen sample3=1*(yearmonth>=ym(2006,01) & yearmonth<=ym(2012,02))
gen sample4=1*(yearmonth>=ym(2006,01) & yearmonth<=ym(2010,02))
gen sample6=1*(yearmonth>=ym(2006,01) & yearmonth<=ym(2018,02))
gen sample7=1*(yearmonth>=ym(2006,01) & yearmonth<=ym(2008,08))

gen ind1 = 1*(yearmonth>ym(2008,01) & yearmonth<=ym(2010,02))
gen ind2 = 1*(yearmonth>ym(2010,02) & yearmonth<=ym(2012,02))
gen ind3 = 1*(yearmonth>ym(2012,02) & yearmonth<=ym(2014,02))
gen ind4 = 1*(yearmonth>ym(2014,02) & yearmonth<=ym(2016,02))
gen ind5 = 1*(yearmonth>ym(2016,02) & yearmonth<=ym(2018,02))

** FILLING GAPS
egen id=group(Area Municipality Community HouseType)
xtset id yearmonth
gen origdata=1
*tsfill, full
replace origdata=0 if origdata==.

*replace year and month of tsfill data
drop YOS MOS
gen date=dofm(yearmonth) 
gen YOS=year(date)
gen MOS=month(date)

*com
bys id: egen aux=mode(Community)
replace Community=aux if Community==""
drop aux

gen x_25=1*(distance<-2500 & distance>-5000)
gen LTT_distance=distance*LTT

rename YOS year
rename MOS month
encode Community, gen(com)

replace BTR_SaleCount = 0 if BTR_SaleCount==.
replace BTO_SaleCount = 0 if BTO_SaleCount==.
replace BTS_SaleCount = 0 if BTS_SaleCount==.
gen BTR_SaleCount_1 = BTR_SaleCount+1



* Generate LTT*Dummy_distance
egen d_max=max(abs(distance))

gen d_25=1*(abs(distance)/d_max <= 0.25)
gen d_50=1*(abs(distance)/d_max>0.25 & abs(distance)/d_max <=0.5)
gen d_75=1*(abs(distance)/d_max>0.5 & abs(distance)/d_max <=0.75)


gen LTT_d25=LTT*d_25
gen LTT_d50=LTT*d_50
gen LTT_d75=LTT*d_75


global loglist Total_SaleCount BTO_SaleCount BTR_SaleCount TotalLease_LeaseCount 

foreach var of varlist $loglist {
	gen ln_`var' = log(`var')
}

***
*Variable 1: ln_BTR_Count_V1
*Sample Restriction: drop top 3% total salescount
*Control: single family houses
*Sample year: Sample 3 (2006-2012)

xtile pct_salecount = Total_SaleCount, nq(100)
gen ln_BTR_Count_V1=ln_BTR_SaleCount 
replace ln_BTR_Count_V1=. if pct_salecount>=97

local l_ln_BTR_Count_V1 "ln(\# BTR Sales)"

***
*Variable 2: ln_BTO_Count_V2
*Sample Restriction: drop top 2% total salescount
*Control: single family houses
*Sample year: Sample 3 (2006-2012)

gen ln_BTO_Count_V2=ln_BTO_SaleCount 
replace ln_BTO_Count_V2=. if pct_salecount>=98

local l_ln_BTO_Count_V2 "ln(\# BTO Sales)"


// * Set up the regression

local sample = "sample3"
local keep = "LTT"
local counter = 1
local cond = " & PropertyType==4"

local FE = "i.year i.month i.com i.toronto" 
local control = "" //"c.yearmonth#c.toronto"

foreach depvar of varlist ln_BTR_Count_V1 ln_BTO_Count_V2{
	eststo clear
	label variable LTT "`depvar'"
	if inlist("`depvar'" ,"Total_SaleCount","BTO_SaleCount","BTR_SaleCount","BTR_SaleCount_1","TotalLease_LeaseCount","Total_AvgSP","BTO_AvgSP","BTR_AvgSP"){
	label variable LTT "ln(`depvar')"
	}

	*2
	qui reghdfe `depvar' post i.toronto LTT i.TO_3m `control' if `sample'==1 & abs(distance)<3000 `cond', a(`FE') vce(robust)
	eststo est2
	estadd local row_dist "3KM":est2
	estadd local row_TO_3m "YES":est2
	estadd local row_time_trend "YES":est2
	
	*5 
	qui reghdfe `depvar' post i.toronto LTT i.TO_3m x_25 `control' if `sample'==1 & abs(distance)<5000 `cond', a(`FE') vce(robust)
	eststo est5
	estadd local row_dist "5KM":est5
	estadd local row_TO_3m "YES":est5
	estadd local row_dist_trend "YES":est5
	estadd local row_time_trend "YES":est5
	
	*6
	qui reghdfe `depvar' post i.toronto LTT i.TO_3m x_25 `control' if `sample'==1 & abs(distance)<5000 & abs(distance)>=2000 `cond', a(`FE') vce(robust)
	eststo est6
	estadd local row_dist "5KM":est6
	estadd local row_TO_3m "YES":est6
	estadd local row_dist_trend "YES":est6
	estadd local row_time_trend "YES":est6
	estadd local row_donut "2KM":est6
	*8
	qui reghdfe `depvar' post i.toronto LTT i.TO_3m LTT_distance `control' if `sample'==1  `cond', a(`FE') vce(robust)
	eststo est8
	estadd local row_dist "ALL":est8
	estadd local row_TO_3m "YES":est8
	estadd local row_time_trend "YES":est8
	estadd local LTT_dist "YES":est8

	label variable LTT "`l_`depvar''"

	if `counter'==1{
	#delimit ;
		esttab using "$path_table_reg/tableA9_`sample'_BTO_BTR_6M.tex", nogaps se star(* 0.1 ** 0.05 *** 0.001) nonumbers nomtitles nonotes keep(`keep') drop(LTT_distance,relax) label replace
		title("OLS LTT on Several Dep Variables (at the yearmonth-Community level)");
	#delimit cr
	}
	else if `counter'==3{
	#delimit ;
		esttab using "$path_table_reg/tableA9_`sample'_BTO_BTR_6M.tex", nogaps se star(* 0.1 ** 0.05 *** 0.001) nonumbers nomtitles keep(`keep') drop(LTT_distance,relax) label append
		scalars("row_dist Distance threshold" "row_TO_3m Indicators TO +-3 m." "row_time_trend Time Trends TO" "row_dist_trend Distance LTT trends" "row_trend Time Trend" "row_donut Donut Hole" "LTT_dist LTT Distance" "LTT_dist_dummy LTT Distance Dummy");
	#delimit cr
	}
	else{
		esttab using "$path_table_reg/tableA9_`sample'_BTO_BTR_6M.tex", nogaps se star(* 0.1 ** 0.05 *** 0.001) nonumbers nomtitles nonotes keep(`keep') drop(LTT_distance,relax) label append
	}
	local counter = `counter'+1
	label variable LTT "LTT"
	
}



*--------------------------------
*** Using 12-month cutoff ****
*--------------------------------

clear all

use "$path_data/Community_12M.dta", clear

merge m:1 Area Municipality Community using "$path_data/community_distance.dta"
keep if _m==3

* yearmonth
rename YR YOS
rename Mn MOS
gen yearmonth=ym(YOS,MOS)
format yearmonth %tm

* houses sample
keep if Area=="Toronto" | (Municipality=="Mississauga" | Municipality=="Brampton" | Municipality=="Vaughan" | Municipality=="Richmond Hill" | Municipality=="Markham" | Municipality=="Pickering")

*rename house types
encode HouseType,gen(PropertyType)

** toronto
gen toronto=1*(Area=="Toronto")
gen post=1*(yearmonth>ym(2008,02))
gen LTT=toronto*post
   
** GENERATING +-6 TO DUMMIES
gen TO_3m=1*(toronto==1 & yearmonth==ym(2007,10))
replace TO_3m=2*(toronto==1 & yearmonth==ym(2007,11)) if TO_3m==0
replace TO_3m=3*(toronto==1 & yearmonth==ym(2007,12)) if TO_3m==0
replace TO_3m=4*(toronto==1 & yearmonth==ym(2008,01)) if TO_3m==0
replace TO_3m=5*(toronto==1 & yearmonth==ym(2008,02)) if TO_3m==0
replace TO_3m=6*(toronto==1 & yearmonth==ym(2008,03)) if TO_3m==0

** SAMPLES **
gen sample3=1*(yearmonth>=ym(2006,01) & yearmonth<=ym(2012,02))
gen sample4=1*(yearmonth>=ym(2006,01) & yearmonth<=ym(2010,02))
gen sample6=1*(yearmonth>=ym(2006,01) & yearmonth<=ym(2018,02))
gen sample7=1*(yearmonth>=ym(2006,01) & yearmonth<=ym(2008,08))

gen ind1 = 1*(yearmonth>ym(2008,01) & yearmonth<=ym(2010,02))
gen ind2 = 1*(yearmonth>ym(2010,02) & yearmonth<=ym(2012,02))
gen ind3 = 1*(yearmonth>ym(2012,02) & yearmonth<=ym(2014,02))
gen ind4 = 1*(yearmonth>ym(2014,02) & yearmonth<=ym(2016,02))
gen ind5 = 1*(yearmonth>ym(2016,02) & yearmonth<=ym(2018,02))

** FILLING GAPS
egen id=group(Area Municipality Community HouseType)
xtset id yearmonth
gen origdata=1
*tsfill, full
replace origdata=0 if origdata==.

*replace year and month of tsfill data
drop YOS MOS
gen date=dofm(yearmonth) 
gen YOS=year(date)
gen MOS=month(date)

*com
bys id: egen aux=mode(Community)
replace Community=aux if Community==""
drop aux

gen x_25=1*(distance<-2500 & distance>-5000)
gen LTT_distance=distance*LTT

rename YOS year
rename MOS month
encode Community, gen(com)

replace BTR_SaleCount = 0 if BTR_SaleCount==.
replace BTO_SaleCount = 0 if BTO_SaleCount==.
replace BTS_SaleCount = 0 if BTS_SaleCount==.
gen BTR_SaleCount_1 = BTR_SaleCount+1



* Generate LTT*Dummy_distance
egen d_max=max(abs(distance))

gen d_25=1*(abs(distance)/d_max <= 0.25)
gen d_50=1*(abs(distance)/d_max>0.25 & abs(distance)/d_max <=0.5)
gen d_75=1*(abs(distance)/d_max>0.5 & abs(distance)/d_max <=0.75)


gen LTT_d25=LTT*d_25
gen LTT_d50=LTT*d_50
gen LTT_d75=LTT*d_75


global loglist Total_SaleCount BTO_SaleCount BTR_SaleCount TotalLease_LeaseCount 

foreach var of varlist $loglist {
	gen ln_`var' = log(`var')
}

***
*Variable 1: ln_BTR_Count_V1
*Sample Restriction: drop top 3% total salescount
*Control: single family houses
*Sample year: Sample 3 (2006-2012)

xtile pct_salecount = Total_SaleCount, nq(100)
gen ln_BTR_Count_V1=ln_BTR_SaleCount 
replace ln_BTR_Count_V1=. if pct_salecount>=97


***
*Variable 2: ln_BTO_Count_V2
*Sample Restriction: drop top 2% total salescount
*Control: single family houses
*Sample year: Sample 3 (2006-2012)

gen ln_BTO_Count_V2=ln_BTO_SaleCount 
replace ln_BTO_Count_V2=. if pct_salecount>=98


local counter = 1

foreach depvar of varlist ln_BTR_Count_V1 ln_BTO_Count_V2{
	eststo clear
	label variable LTT "`depvar'"
	if inlist("`depvar'" ,"Total_SaleCount","BTO_SaleCount","BTR_SaleCount","BTR_SaleCount_1","TotalLease_LeaseCount","Total_AvgSP","BTO_AvgSP","BTR_AvgSP"){
	label variable LTT "ln(`depvar')"
	}
	
	*2
	qui reghdfe `depvar' post i.toronto LTT i.TO_3m `control' if `sample'==1 & abs(distance)<3000 `cond', a(`FE') vce(robust)
	eststo est2
	estadd local row_dist "3KM":est2
	estadd local row_TO_3m "YES":est2
	estadd local row_time_trend "YES":est2
	
	*5 
	qui reghdfe `depvar' post i.toronto LTT i.TO_3m x_25 `control' if `sample'==1 & abs(distance)<5000 `cond', a(`FE') vce(robust)
	eststo est5
	estadd local row_dist "5KM":est5
	estadd local row_TO_3m "YES":est5
	estadd local row_dist_trend "YES":est5
	estadd local row_time_trend "YES":est5
	
	*6
	qui reghdfe `depvar' post i.toronto LTT i.TO_3m x_25 `control' if `sample'==1 & abs(distance)<5000 & abs(distance)>=2000 `cond', a(`FE') vce(robust)
	eststo est6
	estadd local row_dist "5KM":est6
	estadd local row_TO_3m "YES":est6
	estadd local row_dist_trend "YES":est6
	estadd local row_time_trend "YES":est6
	estadd local row_donut "2KM":est6
	*8
	qui reghdfe `depvar' post i.toronto LTT i.TO_3m LTT_distance `control' if `sample'==1  `cond', a(`FE') vce(robust)
	eststo est8
	estadd local row_dist "ALL":est8
	estadd local row_TO_3m "YES":est8
	estadd local row_time_trend "YES":est8
	estadd local LTT_dist "YES":est8

	label variable LTT "`l_`depvar''"
	

	if `counter'==1{
	#delimit ;
		esttab using "$path_table_reg/tableA9_`sample'_BTO_BTR_12M.tex", nogaps se star(* 0.1 ** 0.05 *** 0.001) nonumbers nomtitles nonotes keep(`keep') drop(LTT_distance,relax) label replace
		title("OLS LTT on Several Dep Variables (at the yearmonth-Community level)");
	#delimit cr
	}
	else if `counter'==3{
	#delimit ;
		esttab using "$path_table_reg/tableA9_`sample'_BTO_BTR_12M.tex", nogaps se star(* 0.1 ** 0.05 *** 0.001) nonumbers nomtitles keep(`keep') drop(LTT_distance,relax) label append
		scalars("row_dist Distance threshold" "row_TO_3m Indicators TO +-3 m." "row_time_trend Time Trends TO" "row_dist_trend Distance LTT trends" "row_trend Time Trend" "row_donut Donut Hole" "LTT_dist LTT Distance" "LTT_dist_dummy LTT Distance Dummy");
	#delimit cr
	}
	else{
		esttab using "$path_table_reg/tableA9_`sample'_BTO_BTR_12M.tex", nogaps se star(* 0.1 ** 0.05 *** 0.001) nonumbers nomtitles nonotes keep(`keep') drop(LTT_distance,relax) label append
	}
	local counter = `counter'+1
	label variable LTT "LTT"
	
}


*--------------------------------
*** Using 24-month cutoff ****
*--------------------------------

clear all

use "$path_data/Community_24M.dta", clear

merge m:1 Area Municipality Community using "$path_data/community_distance.dta"
keep if _m==3

* yearmonth
rename YR YOS
rename Mn MOS
gen yearmonth=ym(YOS,MOS)
format yearmonth %tm

* houses sample
keep if Area=="Toronto" | (Municipality=="Mississauga" | Municipality=="Brampton" | Municipality=="Vaughan" | Municipality=="Richmond Hill" | Municipality=="Markham" | Municipality=="Pickering")

*rename house types
encode HouseType,gen(PropertyType)

** toronto
gen toronto=1*(Area=="Toronto")
gen post=1*(yearmonth>ym(2008,02))
gen LTT=toronto*post
   
** GENERATING +-6 TO DUMMIES
gen TO_3m=1*(toronto==1 & yearmonth==ym(2007,10))
replace TO_3m=2*(toronto==1 & yearmonth==ym(2007,11)) if TO_3m==0
replace TO_3m=3*(toronto==1 & yearmonth==ym(2007,12)) if TO_3m==0
replace TO_3m=4*(toronto==1 & yearmonth==ym(2008,01)) if TO_3m==0
replace TO_3m=5*(toronto==1 & yearmonth==ym(2008,02)) if TO_3m==0
replace TO_3m=6*(toronto==1 & yearmonth==ym(2008,03)) if TO_3m==0

** SAMPLES **
gen sample3=1*(yearmonth>=ym(2006,01) & yearmonth<=ym(2012,02))
gen sample4=1*(yearmonth>=ym(2006,01) & yearmonth<=ym(2010,02))
gen sample6=1*(yearmonth>=ym(2006,01) & yearmonth<=ym(2018,02))
gen sample7=1*(yearmonth>=ym(2006,01) & yearmonth<=ym(2008,08))

gen ind1 = 1*(yearmonth>ym(2008,01) & yearmonth<=ym(2010,02))
gen ind2 = 1*(yearmonth>ym(2010,02) & yearmonth<=ym(2012,02))
gen ind3 = 1*(yearmonth>ym(2012,02) & yearmonth<=ym(2014,02))
gen ind4 = 1*(yearmonth>ym(2014,02) & yearmonth<=ym(2016,02))
gen ind5 = 1*(yearmonth>ym(2016,02) & yearmonth<=ym(2018,02))

** FILLING GAPS
egen id=group(Area Municipality Community HouseType)
xtset id yearmonth
gen origdata=1
*tsfill, full
replace origdata=0 if origdata==.

*replace year and month of tsfill data
drop YOS MOS
gen date=dofm(yearmonth) 
gen YOS=year(date)
gen MOS=month(date)

*com
bys id: egen aux=mode(Community)
replace Community=aux if Community==""
drop aux

gen x_25=1*(distance<-2500 & distance>-5000)
gen LTT_distance=distance*LTT

rename YOS year
rename MOS month
encode Community, gen(com)

replace BTR_SaleCount = 0 if BTR_SaleCount==.
replace BTO_SaleCount = 0 if BTO_SaleCount==.
replace BTS_SaleCount = 0 if BTS_SaleCount==.
gen BTR_SaleCount_1 = BTR_SaleCount+1



* Generate LTT*Dummy_distance
egen d_max=max(abs(distance))

gen d_25=1*(abs(distance)/d_max <= 0.25)
gen d_50=1*(abs(distance)/d_max>0.25 & abs(distance)/d_max <=0.5)
gen d_75=1*(abs(distance)/d_max>0.5 & abs(distance)/d_max <=0.75)


gen LTT_d25=LTT*d_25
gen LTT_d50=LTT*d_50
gen LTT_d75=LTT*d_75


global loglist Total_SaleCount BTO_SaleCount BTR_SaleCount TotalLease_LeaseCount 

foreach var of varlist $loglist {
	gen ln_`var' = log(`var')
}

***
*Variable 1: ln_BTR_Count_V1
*Sample Restriction: drop top 3% total salescount
*Control: single family houses
*Sample year: Sample 3 (2006-2012)

xtile pct_salecount = Total_SaleCount, nq(100)
gen ln_BTR_Count_V1=ln_BTR_SaleCount 
replace ln_BTR_Count_V1=. if pct_salecount>=97

***
*Variable 2: ln_BTO_Count_V2
*Sample Restriction: drop top 2% total salescount
*Control: single family houses
*Sample year: Sample 3 (2006-2012)

gen ln_BTO_Count_V2=ln_BTO_SaleCount 
replace ln_BTO_Count_V2=. if pct_salecount>=98

local counter = 1

foreach depvar of varlist ln_BTR_Count_V1 ln_BTO_Count_V2{
	eststo clear
	label variable LTT "`depvar'"
	if inlist("`depvar'" ,"Total_SaleCount","BTO_SaleCount","BTR_SaleCount","BTR_SaleCount_1","TotalLease_LeaseCount","Total_AvgSP","BTO_AvgSP","BTR_AvgSP"){
	label variable LTT "ln(`depvar')"
	}

		
	*2
	qui reghdfe `depvar' post i.toronto LTT i.TO_3m `control' if `sample'==1 & abs(distance)<3000 `cond', a(`FE') vce(robust)
	eststo est2
	estadd local row_dist "3KM":est2
	estadd local row_TO_3m "YES":est2
	estadd local row_time_trend "YES":est2
	
	*5 
	qui reghdfe `depvar' post i.toronto LTT i.TO_3m x_25 `control' if `sample'==1 & abs(distance)<5000 `cond', a(`FE') vce(robust)
	eststo est5
	estadd local row_dist "5KM":est5
	estadd local row_TO_3m "YES":est5
	estadd local row_dist_trend "YES":est5
	estadd local row_time_trend "YES":est5
	
	*6
	qui reghdfe `depvar' post i.toronto LTT i.TO_3m x_25 `control' if `sample'==1 & abs(distance)<5000 & abs(distance)>=2000 `cond', a(`FE') vce(robust)
	eststo est6
	estadd local row_dist "5KM":est6
	estadd local row_TO_3m "YES":est6
	estadd local row_dist_trend "YES":est6
	estadd local row_time_trend "YES":est6
	estadd local row_donut "2KM":est6
	*8
	qui reghdfe `depvar' post i.toronto LTT i.TO_3m LTT_distance `control' if `sample'==1  `cond', a(`FE') vce(robust)
	eststo est8
	estadd local row_dist "ALL":est8
	estadd local row_TO_3m "YES":est8
	estadd local row_time_trend "YES":est8
	estadd local LTT_dist "YES":est8

	label variable LTT "`l_`depvar''"


	if `counter'==1{
	#delimit ;
		esttab using "$path_table_reg/tableA9_`sample'_BTO_BTR_24M.tex", nogaps se star(* 0.1 ** 0.05 *** 0.001) nonumbers nomtitles nonotes keep(`keep') drop(LTT_distance,relax) label replace
		title("OLS LTT on Several Dep Variables (at the yearmonth-Community level)");
	#delimit cr
	}
	else if `counter'==3{
	#delimit ;
		esttab using "$path_table_reg/tableA9_`sample'_BTO_BTR_24M.tex", nogaps se star(* 0.1 ** 0.05 *** 0.001) nonumbers nomtitles keep(`keep') drop(LTT_distance,relax) label append
		scalars("row_dist Distance threshold" "row_TO_3m Indicators TO +-3 m." "row_time_trend Time Trends TO" "row_dist_trend Distance LTT trends" "row_trend Time Trend" "row_donut Donut Hole" "LTT_dist LTT Distance" "LTT_dist_dummy LTT Distance Dummy");
	#delimit cr
	}
	else{
		esttab using "$path_table_reg/tableA9_`sample'_BTO_BTR_24M.tex", nogaps se star(* 0.1 ** 0.05 *** 0.001) nonumbers nomtitles nonotes keep(`keep') drop(LTT_distance,relax) label append
	}
	local counter = `counter'+1
	label variable LTT "LTT"
	
}

log close