        
// *********************************************************************************************************************
// * Table A.10 Hazard alternative periods
// * This file runs  the hazard model for different periods

//  First set global paths running 01_init.do in 00_init
//  Then run this file

// Global variables:
// market_seg: -1 for all segments, 0 for segment 0, 1 for segment 1, 2 for segment 2, -2 for all segments except 2
// prop_type: 1 to 15 for property types, after 6 combinations, see file 01_basic_regs/01_replic_main_table_seg.do
// placebo_border: 0 for no placebo, -2000, -3000, -4000, -5000, -6000 for placebo borders
// crisis_removed: 0 for no crisis removed, 1 for crisis removed
// sampl_num: e for main samplee estimation, see other numbers in 01_basic_regs/01_replic_main_table_seg.do
// default_distances: 0 for default distances, 1 for extended distances thresholds, defined in 01_basic_regs/06_replic_main_table_seg_dist.do
// yearmonthfe: 0 for no yearmonth fixed effects, 1 for yearmonth fixed effects
// crisis_start: crisis start date
// crisis_end: crisis end date

// *********************************************************************************************************************

global dominant_log = 1 // 1 or higher for dominant, 0 for non-dominant
cap log close
log using "$path_logs/12_tableA10_hazard_period.log", replace

// *********************************************************************************************************************
// * Table A.10 Hazard alternative periods
// * This file runs  the hazard model for different periods

global market_seg = 1
global prop_type = 4
global placebo_border = "0"
global crisis_removed = 0
global default_distances = 1
global yearmonthfe = 0 //

global log_name = "12_tableA10_hazard_period.log"

local samples = "6 4"

foreach s in `samples'{


    global sample_number = "sample`s'"
    di "*________________________ Sample `s' _________________________ *"
    do "$dofiles/04_table2_hazard.do"
}

log close
global dominant_log = 0
// *********************************************************************************************************************