// *********************************************************************************************************************
// * Table A.11: Property types
// * This file replicates results in Table 1, to run for smaller samples, like specific property types and fewer years.

//  First set global paths running init.do
//  Second: run global set up variables in 05_run_regs.do

// Required global variables:
// - $path_data
// - $path_table_reg
// - $market_seg
// - $prop_type
// - $winsor


// *********************************************************************************************************************

// *Notes: 

// global market_seg = 0 default market segment

// - LTT is defined as post LTT period and in City of Toronto

// - toronto is defined as the City of Toronto, toronto = 1 if distance < 0

// - distance is defined as the distance from the neighborhood to the Toronto boundary in meters

// - post is defined as year month after or on March 2008

// - community (com) is  is zipcode or postal code

// - property types are: 5 categories
// Att/Row/Twnhouse |     17,361       13.47       13.47
//        Condo Apt |     27,172       21.08       34.55
//  Condo Townhouse |     21,424       16.62       51.17
//         Detached |     40,826       31.67       82.84
//    Semi-Detached |     22,123       17.16      100.00

// Sample definitions: 
// - sample2 is the sample for the main results (Jan 2007 to Feb 2009)
// - sample3 is the main sample for the paper (Jan 2006 to Feb 2012)
// - sample31 is the sample for the robustness checks (Jan 2006 to Feb 2011)
// - sample32 is the sample for the robustness checks (Jan 2006 to Feb 2013)
// - sample4 is the sample for the robustness checks (Jan 2006 to Feb 2010)
// - sample5 is the sample for the extended analysis (Jan 2006 to Feb 2014)
// - sample6 is the sample for the extended analysis (Jan 2006 to Feb 2018)
// - sample8 is the sample for the extended analysis (Jan 2006 to Feb 2016)

// TO_3m is a categorical variable for year/month observations in City of Toronto +- 3 months around the event date (March 2008)

// - x_25 <gen x_25=LTT*(distance<-2500 & distance>-5000)>
// - x_25 is a dummy variable for the 2.5 km donut hole around the LTT boundary

// - LTT_distance is the distance only for LTT = 1 observations (post and in Toronto)


// *********************************************************************************************************************
// * Set up

global dominant_log = 1
cap log close
log using "$path_logs/13_tableA11_prop_types.log", replace

// *********************************************************************************************************************
// * Table A.11: Property types

use "$path_data/Community_18M_distance.dta", clear


local filename = "tableA11_prop"

local add = ""

local sample = "$sample_number"

local keep = "LTT"

local cluster_list = "com year PropertyType" //yearmonth year month  com year com PropertyType 
local cluster = "vce(cluster cluster_group)" //vce(robust)  cluster(cluster_group)
local cluster = "vce(robust)" // default robust

local main_indep_vars = "post toronto LTT i.TO_3m"

local market_segment = $market_seg // 1 if market segment on (main reg in paper), 0 if market segment off by property type

local property_type = $prop_type  // from 1 to 6 $prop_type

// * crisis

local crisis_remove = $crisis_removed // 1 to remove crisis period

local crisis_start = "$crisis_start" // "ym(2008,12)"
local crisis_end = "$crisis_end" //"ym(2009,12)"

local yearmonthfe = $yearmonthfe


// *********************************************************************************************************************

// local add = "`add'_seg`market_segment'"

if `crisis_remove'==1 {

    local add = "`add'_crisis_start`crisis_start'_end`crisis_end'"

    gen crisis_def= 1*(yearmonth>=`crisis_start' & yearmonth<=`crisis_end')

    drop if crisis_def==1
}

// ******* Reg FE and controls *****************************************************************************************
local FE = "i.PropertyType##i.year i.toronto##i.PropertyType i.month##i.PropertyType i.com##i.PropertyType " //i.

local control = "c.yearmonth#c.toronto"

local dist_control = "x_25" //LTT_distance

local dist = 20000

// local add = "`add'_dist`dist'"

local filename = "`filename'_`sample'`add'"
// *********************************************************************************************************************
// * Creating new variables

egen cluster_group = group(`cluster_list')

gen leasesales_ratio = TotalLease_LeaseCount/Total_SaleCount
gen ln_leasesales_ratio= log(leasesales_ratio)

xtile pct_salecount = Total_SaleCount, nq(100)

// * BTO and BTR except for places with 98% percentile or more of the sales
gen ln_BTO_Count_E12=ln_BTO_SaleCount 
replace ln_BTO_Count_E12=. if pct_salecount>=98

gen ln_BTR_Count_E13=ln_BTR_SaleCount 
replace ln_BTR_Count_E13=. if pct_salecount>=97

xtile pct_BTRcount = BTR_SaleCount, nq(100)
gen ln_BTR_Count_E04=ln_BTR_SaleCount 
replace ln_BTR_Count_E04=. if pct_BTRcount>=95 

// *price to rent ratio with more than 1 sale and lease
gen ln_PRRatio_Avg=log(Total_PRRatio_Avg) 
gen ln_PRRatio_Avg_H2 = ln_PRRatio_Avg
replace ln_PRRatio_Avg_H2=. if Total_PRRatio_Avg==0 | TotalLease_LeaseCount==1 | Total_SaleCount==1


// *********************************************************************************************************************
// * Labels

local l_ln_BTO_SaleCount "log(BTR Sales)"
local l_ln_BTR_SaleCount "log(BTO Sales)"
local l_ln_BTO_SaleCount_w "log(BTR Sales)"
local l_ln_BTR_SaleCount_w "log(BTO Sales)"
local l_ln_Total_SaleCount "log(\# Sales)"
local l_ln_TotalLease_LeaseCount "log(\# Leases)"
local l_ln_Total_SaleCount_w "log(\# Sales)"
local l_ln_TotalLease_LeaseCount_w "log(\# Leases)"
local l_ln_BTO_Count_E12 "log(BTO Sales)"
local l_ln_BTR_Count_E13 "log(BTR Sales)"
local l_ln_BTR_Count_E04 "log(BTR Sales)"
local l_ln_leasesales_ratio "log(Lease/Sales)"
local l_ln_PRRatio_Avg "log(Price/Rent)"
local l_ln_PRRatio_Avg_H2 "log(Price/Rent)"
local l_ln_rent "log(Rent)"
local l_ln_rent_w "log(Rent)"
local l_ln_Total_AvgSP "log(Price)"


// *********************************************************************************************************************


di "Property types regs"

di "Filename: `filename'"

di "Sample: `sample'"
di "Sample number: `num'"
di "Market segment: `market_segment'"
di "Property type: `property_type'"
di "Crisis removed: `crisis_remove'"
di "Min distance: `min_dist'"
di "Cluster: `cluster'"
di "Cluster list: `cluster_list'"
di "Main independent variables: `main_indep_vars'"
di "Additional: `add'"
di "Keep: `keep'"
di "Control: `control'"
di "cond: `cond_'"


// *********************************************************************************************************************
// * Regressions
// * *********************************************************************************************************************


// *********************************************************************************************************************
// * Lease/Sales Ratio
// *********************************************************************************************************************
local FE = "i.PropertyType##i.year i.toronto##i.PropertyType i.month##i.PropertyType i.com##i.PropertyType " //i.

local depvar = "ln_leasesales_ratio" // from main result of paper table


eststo clear


// * Property Type 6: Detached Semidetached

local cond = " & (PropertyType==4| PropertyType==5)"

qui reghdfe `depvar' `main_indep_vars' `dist_control' `control' if `sample'==1  & abs(distance)<`dist' `cond', a(`FE') `cluster'

eststo est6

estadd local row_det "YES":est6
estadd local row_semi "YES":est6
estadd local row_condoA "NO":est6
estadd local row_condoT "NO":est6
estadd local row_ "NO":est6


// * Property Type 13: Detached Condo Apt

local cond = " & (PropertyType==2| PropertyType==4)"

qui reghdfe `depvar' `main_indep_vars' `dist_control' `control' if `sample'==1  & abs(distance)<`dist' `cond', a(`FE') `cluster'

eststo est13

estadd local row_det "YES":est13
estadd local row_semi "NO":est13
estadd local row_condoA "YES":est13
estadd local row_condoT "NO":est13
estadd local row_ "NO":est13


// * Property Type  11" Detached Semdetached Condo Apt

local cond = "& (PropertyType==2| PropertyType==4| PropertyType==5)"

qui reghdfe `depvar' `main_indep_vars' `dist_control' `control' if `sample'==1  & abs(distance)<`dist' `cond', a(`FE') `cluster'

eststo est11

estadd local row_det "YES":est11
estadd local row_semi "YES":est11
estadd local row_condoA "YES":est11
estadd local row_condoT "NO":est11
estadd local row_ "NO":est11


// * Property Type  8: Det Semi  Condo A, Condo Townhouse

local cond = "& (PropertyType==2| PropertyType==3| PropertyType==4| PropertyType==5)"

qui reghdfe `depvar' `main_indep_vars' `dist_control' `control' if `sample'==1  & abs(distance)<`dist' `cond', a(`FE') `cluster'

eststo est8

estadd local row_det "YES":est8
estadd local row_semi "YES":est8
estadd local row_condoA "YES":est8
estadd local row_condoT "YES":est8
estadd local row_ "NO":est8


// * Property Type  ALL: Det Semi  Condo A, Condo Townhouse

local cond = ""

qui reghdfe `depvar' `main_indep_vars' `dist_control' `control' if `sample'==1  & abs(distance)<`dist' `cond', a(`FE') `cluster'

eststo est0

estadd local row_det "YES":est0
estadd local row_semi "YES":est0
estadd local row_condoA "YES":est0
estadd local row_condoT "YES":est0
estadd local row_ "YES":est0


label variable LTT "`l_`depvar''"

esttab, nogaps se star(* 0.1 ** 0.05 *** 0.001) nonumbers nomtitles nonotes keep(`keep') drop(`dist_control',relax) label 

esttab using "$path_table_reg/`filename'.tex", nogaps se star(* 0.1 ** 0.05 *** 0.001) nonumbers nomtitles nonotes keep(`keep') drop(`dist_control',relax) label replace


// *********************************************************************************************************************
// * Price/Rent Ratio
// *********************************************************************************************************************

local depvar = "ln_PRRatio_Avg_H2"
// local FE = "i.year##i.PropertyType i.toronto##i.PropertyType i.month##i.PropertyType i.com##i.PropertyType"
//local FE = ""

eststo clear

// * Property Type 6: Detached Semidetached

local cond = " & (PropertyType==4| PropertyType==5)"

qui reghdfe `depvar' `main_indep_vars' `dist_control' `control' if `sample'==1  & abs(distance)<`dist' `cond', a(`FE') `cluster'

eststo est6

estadd local row_det "YES":est6
estadd local row_semi "YES":est6
estadd local row_condoA "NO":est6
estadd local row_condoT "NO":est6
estadd local row_ "NO":est6


// * Property Type 13: Detached Condo Apt

local cond = " & (PropertyType==2| PropertyType==4)"

qui reghdfe `depvar' `main_indep_vars' `dist_control' `control' if `sample'==1  & abs(distance)<`dist' `cond', a(`FE') `cluster'

eststo est13

estadd local row_det "YES":est13
estadd local row_semi "NO":est13
estadd local row_condoA "YES":est13
estadd local row_condoT "NO":est13
estadd local row_ "NO":est13


// * Property Type  11" Detached Semdetached Condo Apt

local cond = "& (PropertyType==2| PropertyType==4| PropertyType==5)"

qui reghdfe `depvar' `main_indep_vars' `dist_control' `control' if `sample'==1  & abs(distance)<`dist' `cond', a(`FE') `cluster'

eststo est11

estadd local row_det "YES":est11
estadd local row_semi "YES":est11
estadd local row_condoA "YES":est11
estadd local row_condoT "NO":est11
estadd local row_ "NO":est11


// * Property Type  8: Det Semi  Condo A, Condo Townhouse

local cond = "& (PropertyType==2| PropertyType==3| PropertyType==4| PropertyType==5)"

qui reghdfe `depvar' `main_indep_vars' `dist_control' `control' if `sample'==1  & abs(distance)<`dist' `cond', a(`FE') `cluster'

eststo est8

estadd local row_det "YES":est8
estadd local row_semi "YES":est8
estadd local row_condoA "YES":est8
estadd local row_condoT "YES":est8
estadd local row_ "NO":est8


// * Property Type  ALL: Det Semi  Condo A, Condo Townhouse

local cond = ""

qui reghdfe `depvar' `main_indep_vars' `dist_control' `control' if `sample'==1  & abs(distance)<`dist' `cond', a(`FE') `cluster'

eststo est0

estadd local row_det "YES":est0
estadd local row_semi "YES":est0
estadd local row_condoA "YES":est0
estadd local row_condoT "YES":est0
estadd local row_ "YES":est0



label variable LTT "`l_`depvar''"


esttab, nogaps se star(* 0.1 ** 0.05 *** 0.001) nonumbers nomtitles nonotes keep(`keep') drop(`dist_control',relax) label 


esttab using "$path_table_reg/`filename'.tex", nogaps se star(* 0.1 ** 0.05 *** 0.001) nonumbers nomtitles nonotes keep(`keep') drop(`dist_control',relax) label append


// *********************************************************************************************************************
// * BTO
// *********************************************************************************************************************

local depvar = "ln_BTO_Count_E12" // from main result of paper table


eststo clear

// * Property Type 6: Detached Semidetached

local cond = " & (PropertyType==4| PropertyType==5)"

qui reghdfe `depvar' `main_indep_vars' `dist_control' `control' if `sample'==1  & abs(distance)<`dist' `cond', a(`FE') `cluster'

eststo est6

estadd local row_det "YES":est6
estadd local row_semi "YES":est6
estadd local row_condoA "NO":est6
estadd local row_condoT "NO":est6
estadd local row_ "NO":est6


// * Property Type 13: Detached Condo Apt

local cond = " & (PropertyType==2| PropertyType==4)"

qui reghdfe `depvar' `main_indep_vars' `dist_control' `control' if `sample'==1  & abs(distance)<`dist' `cond', a(`FE') `cluster'

eststo est13

estadd local row_det "YES":est13
estadd local row_semi "NO":est13
estadd local row_condoA "YES":est13
estadd local row_condoT "NO":est13
estadd local row_ "NO":est13


// * Property Type  11" Detached Semdetached Condo Apt

local cond = "& (PropertyType==2| PropertyType==4| PropertyType==5)"

qui reghdfe `depvar' `main_indep_vars' `dist_control' `control' if `sample'==1  & abs(distance)<`dist' `cond', a(`FE') `cluster'

eststo est11

estadd local row_det "YES":est11
estadd local row_semi "YES":est11
estadd local row_condoA "YES":est11
estadd local row_condoT "NO":est11
estadd local row_ "NO":est11


// * Property Type  8: Det Semi  Condo A, Condo Townhouse

local cond = "& (PropertyType==2| PropertyType==3| PropertyType==4| PropertyType==5)"

qui reghdfe `depvar' `main_indep_vars' `dist_control' `control' if `sample'==1  & abs(distance)<`dist' `cond', a(`FE') `cluster'

eststo est8

estadd local row_det "YES":est8
estadd local row_semi "YES":est8
estadd local row_condoA "YES":est8
estadd local row_condoT "YES":est8
estadd local row_ "NO":est8


// * Property Type  ALL: Det Semi  Condo A, Condo Townhouse

local cond = ""

qui reghdfe `depvar' `main_indep_vars' `dist_control' `control' if `sample'==1  & abs(distance)<`dist' `cond', a(`FE') `cluster'

eststo est0

estadd local row_det "YES":est0
estadd local row_semi "YES":est0
estadd local row_condoA "YES":est0
estadd local row_condoT "YES":est0
estadd local row_ "YES":est0


label variable LTT "`l_`depvar''"


esttab, nogaps se star(* 0.1 ** 0.05 *** 0.001) nonumbers nomtitles nonotes keep(`keep') drop(`dist_control',relax) label 


esttab using "$path_table_reg/`filename'.tex", nogaps se star(* 0.1 ** 0.05 *** 0.001) nonumbers nomtitles nonotes keep(`keep') drop(`dist_control',relax) label append

// *********************************************************************************************************************
// * BTR
// *********************************************************************************************************************

local control = ""

local dist_control = "LTT_d25 LTT_d50 LTT_d75 "

eststo clear

// * Property Type 6: Detached Semidetached

local cond = " & (PropertyType==4| PropertyType==5)"

qui reghdfe `depvar' `main_indep_vars' `dist_control' `control' if `sample'==1  & abs(distance)<`dist' `cond', a(`FE') `cluster'

eststo est6

estadd local row_det "YES":est6
estadd local row_semi "YES":est6
estadd local row_condoA "NO":est6
estadd local row_condoT "NO":est6
estadd local row_ "NO":est6


// * Property Type 13: Detached Condo Apt

local cond = " & (PropertyType==2| PropertyType==4)"

qui reghdfe `depvar' `main_indep_vars' `dist_control' `control' if `sample'==1  & abs(distance)<`dist' `cond', a(`FE') `cluster'

eststo est13

estadd local row_det "YES":est13
estadd local row_semi "NO":est13
estadd local row_condoA "YES":est13
estadd local row_condoT "NO":est13
estadd local row_ "NO":est13


// * Property Type  11" Detached Semdetached Condo Apt

local cond = "& (PropertyType==2| PropertyType==4| PropertyType==5)"

qui reghdfe `depvar' `main_indep_vars' `dist_control' `control' if `sample'==1  & abs(distance)<`dist' `cond', a(`FE') `cluster'

eststo est11

estadd local row_det "YES":est11
estadd local row_semi "YES":est11
estadd local row_condoA "YES":est11
estadd local row_condoT "NO":est11
estadd local row_ "NO":est11


// * Property Type  8: Det Semi  Condo A, Condo Townhouse

local cond = "& (PropertyType==2| PropertyType==3| PropertyType==4| PropertyType==5)"

qui reghdfe `depvar' `main_indep_vars' `dist_control' `control' if `sample'==1  & abs(distance)<`dist' `cond', a(`FE') `cluster'

eststo est8

estadd local row_det "YES":est8
estadd local row_semi "YES":est8
estadd local row_condoA "YES":est8
estadd local row_condoT "YES":est8
estadd local row_ "NO":est8


// * Property Type  ALL: Det Semi  Condo A, Condo Townhouse

local cond = ""

qui reghdfe `depvar' `main_indep_vars' `dist_control' `control' if `sample'==1  & abs(distance)<`dist' `cond', a(`FE') `cluster'

eststo est0

estadd local row_det "YES":est0
estadd local row_semi "YES":est0
estadd local row_condoA "YES":est0
estadd local row_condoT "YES":est0
estadd local row_ "YES":est0

label variable LTT "`l_`depvar''"

esttab, nogaps se star(* 0.1 ** 0.05 *** 0.001) nonumbers nomtitles nonotes keep(`keep') drop(`dist_control',relax) label 

esttab using "$path_table_reg/`filename'.tex", nogaps se star(* 0.1 ** 0.05 *** 0.001) nonumbers nomtitles nonotes keep(`keep')  label append ///
			scalars("row_det Detached" "row_semi Semi-detached" "row_condoA Condo Apartments" "row_condoT Condo Townhouse" "row_ Row/Attached/Townhouse")	


// *********************************************************************************************************************

log close
global dominant_log = 0