% Produce probability density function of credit-cost distribution

% Create a grid for the horizontal axis
ng = 1000;
k = ((1/ng):(1/ng):1)';

% Set baseline calibration targets
tgt = targets();
matchregression;

% Run for two calibrations
for c=1:2

    % Alternative calibration
    if (c == 2)
        tgt.rz = 0.0793;
    end

    % Determine parameters and steady state
    prm = calibration(tgt);
    res = predict(prm);
    
    % Extract information
    mu = prm.mu;
    sig = prm.sig;
    Ph = res.PPh;
    z = res.Z/Ph;
    
    % Calculate density function
    dens = (1/sig)*(1./k).*normpdf((1/sig)*(log(k) + log(Ph) - mu ));
    
    % Plot results
    figure;
    plot(k,dens);
    hold on;
    drange = ylim;
    plot([z;z],[drange(1);drange(2)])
    xlabel('Credit cost/Price');
    if (c == 1)
        title('Baseline mortgage-rate gap of 1.5%');
    else
        title('Alternative mortgage-rate gap of 3%');
    end

end
