function vars = findvars(pt,prm)
% Find variables of the model conditional on psi and thetao

%% Extract vector elements
ps = pt(1);
thetao = pt(2);

%% Solve for ownership market thresholds

% Modified bargaining powers
omegash = prm.omegah/(1 + prm.tauh*(1-prm.omegah));
omegasi = prm.omegai/(1 + prm.taui*(1-prm.omegai));

% Meeting rate for buyers
vars.vo = prm.upsilono*(thetao^(-prm.etao));

% Package information needed to solve for homeowner thresholds
prmh = struct('ps',ps,'thetao',thetao,'vo',vars.vo,'zetah',prm.zetah,'lambdah',prm.lambdah,'r',prm.r,'Co',prm.Co,'Ch',prm.Ch, ...
    'Fh',prm.Fh,'Fi',prm.Fi,'D',prm.D,'rho',prm.rho,'alphah',prm.alphah,'deltah',prm.deltah,'omegash',omegash,'omegasi',omegasi,'tauh',prm.tauh);

% Solve for transaction threshold for home-buyers
vars.yh = solveownthres(prmh);
if isnan(vars.yh)
    return;
end

% Probability of a successful home-buyer viewing
vars.pih = (prm.zetah/vars.yh)^prm.lambdah;

% Selling rate and fraction of purchases by investors
vars.ii = ps/(ps + (1-ps)*vars.pih);
vars.so = thetao*vars.vo*(ps + (1-ps)*vars.pih);

% Moving threshold for homeowners
vars.xh = (vars.yh - (prm.r + prm.rho + prm.alphah)*(prm.Ch + (1+prm.tauh)*prm.Co - prm.tauh*(prm.D/prm.r) ...
    + prm.tauh*(thetao/(1 - omegash + omegash*(1-ps)*thetao))*( omegash*(1-ps)*(prm.Fh/prm.r) ...
    + ((1-omegash)/(1-omegasi))*omegasi*ps*(prm.Fi/prm.r) ) ) )/( 1 ... 
    + prm.tauh*(omegash*(1-ps)*thetao/(1 - omegash + omegash*(1-ps)*thetao))*((prm.r+prm.rho+prm.alphah)/prm.r) );

% Investors' surplus
vars.Sigmai = prm.Fi/((1-omegasi)*vars.vo);

% Home-buyers' surplus
vars.Sigmah = (vars.xh + prm.Fh - omegasi*ps*thetao*vars.vo*vars.Sigmai)/(vars.vo*(1 - omegash + omegash*(1-ps)*thetao));

% Moving rate within the city for homeowners
vars.mh = prm.alphah*(prm.rho + prm.alphah*(1 - prm.deltah^prm.lambdah) - prm.rho*((prm.deltah*vars.yh/vars.xh)^prm.lambdah))/(prm.rho ... 
    + prm.alphah*(1 - prm.deltah^prm.lambdah) + prm.alphah*((prm.deltah*vars.yh/vars.xh)^prm.lambdah));

% Stock for sale and owner-occupied stock
vars.uo = 1/(1 + ((1-vars.ii)*vars.so/(vars.mh+prm.rho)) + (vars.ii*vars.so/prm.rhol) );
vars.qh = ((1-vars.ii)*vars.so/(vars.mh+prm.rho))*vars.uo;

% Tax revenue
vars.GG = prm.tauh*vars.vo*vars.pih*(1-ps)*thetao*vars.uo*( prm.Co - (prm.D/prm.r) + ((prm.r ... 
    + thetao*vars.vo*(1-ps)*vars.pih)/prm.r)*(omegash*vars.Sigmah/vars.pih) + thetao*vars.vo*ps*omegasi*vars.Sigmai/prm.r ) ... 
    + prm.taui*vars.vo*ps*thetao*vars.uo*( prm.Co - (prm.D/prm.r) + (1-ps)*(thetao*vars.vo/prm.r)*omegash*vars.Sigmah ...
    + (1 + (thetao*vars.vo/prm.r)*ps)*(omegasi/(1-omegasi))*(prm.Fi/vars.vo) );

%% Solve for rental market threshold and other rental-market variables

% Moving rate in rental market
vars.ml = prm.alphal + prm.rhol;

% Package information needed to solve for rental threshold
prml = struct('thetao',thetao,'ps',ps,'vo',vars.vo,'Sigmah',vars.Sigmah,'Sigmai',vars.Sigmai,'qh',vars.qh,'uo',vars.uo,'pih',vars.pih,'mh',vars.mh,'GG',vars.GG,'E',prm.E, ...
    'ml',vars.ml,'zetal',prm.zetal,'lambdal',prm.lambdal,'r',prm.r,'Co',prm.Co,'Ci',prm.Ci,'Cl',prm.Cl,'Cw',prm.Cw,'Fl',prm.Fl,'D',prm.D,'Dl',prm.Dl, ...
    'mu',prm.mu,'sig',prm.sig,'xi',prm.xi,'rho',prm.rho,'rhol',prm.rhol,'upsilonl',prm.upsilonl,'etal',prm.etal,'omegash',omegash,'omegasi',omegasi,'omegal',prm.omegal,'taui',prm.taui);

% Solve for rental transaction threshold
vars.yl = solverentthres(prml);
if isnan(vars.yl)
    return;
end

% Calculate rental-market variables conditional on yl
rvar = rentalvars(vars.yl,prml);
vars.pil = rvar.pil;
vars.sl = rvar.sl;
vars.Sigmal = rvar.Sigmal;
vars.thetal = rvar.thetal;
vars.vl = rvar.vl;
vars.ul = rvar.ul;
vars.ql = rvar.ql;
vars.kappa = rvar.kappa;
vars.n = rvar.n;
vars.Z = rvar.Z;
vars.Kbar = rvar.Kbar;

%% Calculate criteria for model solution

% Two equations to check
vars.eqn1 = (vars.n-1) - ((1-ps)*thetao - 1)*vars.uo - (vars.thetal - 1)*vars.ul;
vars.eqn2 = (1-omegash)*vars.vo*vars.Sigmah - (1-prm.omegal)*vars.vl*vars.Sigmal - (prm.r+prm.rho)*vars.Z - prm.Fh + prm.Fl;

end
