% Calibrate to match dynamic simulations to regression for one variable

% Variable to target and horizon for simulation of model
regtarget = 'Tmhinv';
regyrs = 4;
regcoeff = tgt.betamh;
taxnew = [0.0285;0.0285];

% Main loop
disp('Starting process of matching regression result');
varkappa = tgt.varkappa;
regerr = 1;
regcount = 1;
while (abs(regerr) >= 1e-6)

    % Report progress
    fprintf('Matching regression result: Iteration %d\n',regcount);
    disp([tgt.varkappa regerr]);
    
    % Set new value of varkappa and calibrate other parameters
    tgt.varkappa = varkappa;
    prm = calibration(tgt);

    % Solve dynamic model
    dynare rentown.mod;

    % Find target variable index and number of discrete time periods per year
    vidx = find(strcmp(M_.endo_names,regtarget));
    py = round(1/M_.params(find(strcmp(M_.param_names,'ell'))));
    
    % Average response of target variable 
    avresp = mean(log(oo_.endo_simul(vidx,2:(2+py*regyrs))') - log(oo_.endo_simul(vidx,1)));
    
    % Error and updated value of varkappa
    regerr = (avresp-regcoeff)/regcoeff;
    varkappa = (1-regerr)*varkappa;
    regcount = regcount + 1;
    
end

% Save final varkappa parameter
tgt.varkappa = varkappa;
disp('Converged to match regression result');
