function crit = ownthrescrit(yh,prm)
% Criterion to find transaction threshold for home-buyers

% Implied moving threshold for homeowners
xh = (yh - (prm.r + prm.rho + prm.alphah)*(prm.Ch + (1+prm.tauh)*prm.Co - prm.tauh*(prm.D/prm.r) ... 
    + prm.tauh*(prm.thetao/(1 - prm.omegash + prm.omegash*(1-prm.ps)*prm.thetao))*( prm.omegash*(1-prm.ps)*(prm.Fh/prm.r) ...
    + ((1-prm.omegash)/(1-prm.omegasi))*prm.omegasi*prm.ps*(prm.Fi/prm.r) ) ) )/( 1 ... 
    + prm.tauh*(prm.omegash*(1-prm.ps)*prm.thetao/(1 - prm.omegash + prm.omegash*(1-prm.ps)*prm.thetao))*((prm.r+prm.rho+prm.alphah)/prm.r) );

% Evaluate criterion for transaction threshold
crit = (prm.vo*(prm.zetah^prm.lambdah)*(1 - prm.omegash + prm.omegash*(1-prm.ps)*prm.thetao)/((1 + prm.tauh*prm.omegash)*(prm.lambdah-1)*(prm.r + prm.rho + prm.alphah)))*( ... 
    yh^(1-prm.lambdah) + (prm.alphah*(prm.deltah^prm.lambdah)/(prm.r + prm.rho + prm.alphah*(1 - prm.deltah^prm.lambdah)))*(xh^(1-prm.lambdah)) ) ... 
    + (prm.omegasi*prm.ps*prm.thetao*prm.Fi/(1-prm.omegasi)) - xh - prm.Fh;

end
