function res = predict(prm)
% Obtain predictions of the model for given parameters

% Error tolerance in finding solution
errtol = 1e-10;

% Solve the model
[pt,~,exitflag] = fminsearch(@modelcrit,prm.pt0,optimset('TolFun',errtol,'TolX',errtol),prm);
if (exitflag < 1)
    res = struct;
    disp('No solution found');
    return;
end
disp('Solution found');

% Get other variables
res = findvars(pt,prm);

% Investor share and ownership market tightness
res.ps = pt(1);
res.thetao = pt(2);

% Modified bargaining powers
omegash = prm.omegah/(1 + prm.tauh*(1-prm.omegah));
omegasi = prm.omegai/(1 + prm.taui*(1-prm.omegai));

% Flow of new arrivals to city
res.a = prm.rho*res.n;

% Buyers/renters
res.bh = (1-res.ps)*res.thetao*res.uo;
res.bi = res.ps*res.thetao*res.uo;
res.bo = res.thetao*res.uo;
res.bl = res.thetal*res.ul;

% First-time buyers
res.phi = prm.rho*(1 + ((res.mh+prm.rho)/(res.vo*res.pih)))/( res.mh + prm.rho*(1 + ((res.mh+prm.rho)/(res.vo*res.pih)) ) );
res.aleph = (1 + (prm.rho/(prm.rho + res.ml + res.vl*res.pil)) )*( (1/prm.rho) - (1/( prm.rho ... 
    + (prm.xi*res.ml*res.vl*res.pil/(prm.rho + res.ml + res.vl*res.pil)) )) );

% Time-to-sell, time-to-buy, and viewings
res.Tso = 1/res.so;
res.Tbh = 1/(res.vo*res.pih);
res.LLambdah = 1/res.pih;
res.Tsl = 1/res.sl;
res.Tbl = 1/(res.vl*res.pil);
res.LLambdal = 1/res.pil;

% Measure of viewings
res.nuhbar = (1-res.ps)*res.thetao*res.vo*res.uo;

% Transactions
res.SSh = res.vo*res.pih*res.bh;
res.SSi = res.vo*res.bi;
res.SSo = res.SSh + res.SSi;
res.SSl = res.sl*res.ul;
res.SSlo = res.SSl/res.SSo;

% Time-to-move
res.Tmh = 1/(res.mh + prm.rho);
res.Tml = 1/(res.ml + prm.rho);
res.Tmhinv = 1/res.Tmh;

% Prices and rents
res.PPh = prm.Co - (prm.D/prm.r) + ((prm.r + res.thetao*res.vo*(1-res.ps)*res.pih)/prm.r)*(omegash*res.Sigmah/res.pih) + res.thetao*res.vo*res.ps*omegasi*res.Sigmai/prm.r;
res.PPi = prm.Co - (prm.D/prm.r) + (1-res.ps)*(res.thetao*res.vo/prm.r)*omegash*res.Sigmah + (1 + (res.thetao*res.vo/prm.r)*res.ps)*(omegasi/(1-omegasi))*(prm.Fi/res.vo);
res.pii = res.PPi/res.PPh;
res.RR = prm.Dl + prm.omegal*(prm.r + prm.rho + res.ml)*(prm.Cl + prm.Cw) + (prm.r + prm.rho + res.ml + res.sl)*(prm.omegal*res.Sigmal/res.pil);
res.RRbar = res.RR;
res.pr = res.PPi/res.RR;
res.PP = (1-res.ii)*res.PPh + res.ii*res.PPi;

% Homeownership rate
res.h = (res.qh + res.bh)/res.n;

% Flow of first-time buyers
res.gamma = (prm.xi*res.ml*res.ql + prm.rho*res.n)*res.kappa;

% Average match quality
res.VVh = (prm.lambdah/(prm.lambdah-1))*( ((res.mh+prm.rho)/(prm.alphah+prm.rho))*res.yh + ((prm.alphah-res.mh)/(prm.alphah+prm.rho))*res.xh );
res.VVl = (prm.lambdal/(prm.lambdal-1))*res.yl;

% Per-capita public expenditure and PDV of all future spending
res.g = res.GG/res.n;
res.PPPi = res.GG/prm.r;

% Total welfare
res.Omega = (1/prm.r)*( res.qh*res.VVh + res.ql*res.VVl - prm.D - res.ql*prm.Dl - res.bh*prm.Fh - res.bi*prm.Fi - res.bl*prm.Fl ...
    - res.SSl*(prm.Cl + prm.Cw) - res.SSi*prm.Ci - res.SSh*prm.Ch - res.SSo*prm.Co - res.gamma*res.Kbar - res.a*prm.E);

% Distributional effects
res.UUo = (1/prm.r)*( res.thetao*res.vo*( (1-res.ps)*omegash*res.Sigmah + res.ps*omegasi*res.Sigmai ) - prm.D );
res.UUl = (1/(prm.r + prm.rhol))*( prm.omegal*res.thetal*res.vl*res.Sigmal - prm.D + prm.rhol*res.UUo );
res.BBh = (1/(prm.r + prm.rho))*( (1-omegash)*res.vo*res.Sigmah - prm.Fh + res.g );
res.BBl = (1/(prm.r + prm.rho))*( (1-prm.omegal)*res.vl*res.Sigmal - prm.Fl + res.g );
res.NN = (1-res.kappa)*res.BBl + res.kappa*(res.BBh - res.Kbar) - prm.E;
res.HH = (1/prm.r)*( res.VVh + res.g - prm.D + res.mh*(res.BBh + res.UUo) + prm.rho*res.UUo - (res.pih*res.vo*res.bh/res.qh)*( (1+prm.tauh*omegash)*(res.Sigmah/res.pih) ...
    + prm.Ch + (1+prm.tauh)*prm.Co + res.BBh + (1+prm.tauh)*res.UUo ) );
res.LL = (1/prm.r)*( res.RR - prm.D - prm.Dl + (res.ml - prm.rhol + prm.rho)*res.UUl + prm.rhol*res.UUo ...
    - (res.pil*res.vl*res.bl/res.ql)*( res.UUl + prm.omegal*(prm.Cw + prm.Cl) + prm.omegal*(res.Sigmal/res.pil) ) );
res.WW = (1/prm.r)*( res.VVl + res.g - res.RR + res.ml*res.BBl + prm.xi*res.ml*res.kappa*(res.Z - res.Kbar) ...
    - (res.pil*res.vl*res.bl/res.ql)*( res.BBl + (1-prm.omegal)*(prm.Cw + prm.Cl) + (1-prm.omegal)*(res.Sigmal/res.pil) ) );
res.Omegaa = res.a*res.NN/prm.r;

% Thresholds
res.XXh = res.xh;
res.HHubar = res.BBh + res.UUo - (res.xh/(prm.r + prm.rho + prm.alphah));
res.JJubar = res.BBl + res.UUl + prm.Cl + prm.Cw - (res.yl/(prm.r + prm.rho + res.ml));

% Remove unnecessary information
res = rmfield(res,{'eqn1';'eqn2'});

end
