function rvar = rentalvars(yl,prml)
% Find rental-market variables conditional on transaction threshold yl

% Probability of a successful viewing
rvar.pil = (prml.zetal/yl)^prml.lambdal;

% Rental market surplus
rvar.Sigmal = rvar.pil*yl/((prml.lambdal-1)*(prml.r + prml.rho + prml.ml));

% Letting rate
rvar.sl = ((prml.lambdal-1)*(prml.r + prml.rho + prml.ml)/(prml.omegal*yl))*( (prml.r + prml.rhol)*(prml.Ci + (1+prml.taui)*prml.Co) ... 
    - prml.taui*(1 + (prml.rhol/prml.r))*prml.D + (prml.r+prml.rhol)*(1 + prml.taui*prml.omegasi)*prml.Sigmai + ...
    (1 + prml.taui*(1 + (prml.rhol/prml.r)))*prml.thetao*prml.vo*( (1-prml.ps)*prml.omegash*prml.Sigmah + prml.ps*prml.omegasi*prml.Sigmai ) );

% Market tightness
rvar.thetal = (rvar.sl/(prml.upsilonl*rvar.pil))^(1/(1-prml.etal));

% Meeting rate
rvar.vl = prml.upsilonl*(rvar.thetal^(-prml.etal));

% Stock to let and occupied rental stock
rvar.ul = (1-prml.qh-prml.uo)/(1 + (rvar.sl/(prml.ml+prml.rho)));
rvar.ql = (rvar.sl/(prml.ml+prml.rho))*rvar.ul;

% Find fraction choosing to pay credit cost
prmk = struct('mu',prml.mu,'sig',prml.sig,'GG',prml.GG,'thetao',prml.thetao,'ps',prml.ps,'vo',prml.vo,'pih',prml.pih,'mh',prml.mh,'qh',prml.qh,'uo',prml.uo, ...
    'ml',prml.ml,'ql',rvar.ql,'ul',rvar.ul,'vl',rvar.vl,'Sigmal',rvar.Sigmal,'xi',prml.xi,'rho',prml.rho,'r',prml.r,'omegal',prml.omegal,'Fl',prml.Fl,'E',prml.E);
if credcostcrit(eps,prmk) >= 0
    rvar.kappa = eps;
elseif credcostcrit(1-eps,prmk) <= 0
    rvar.kappa = 1 - eps;
else
    rvar.kappa = fzero(@credcostcrit,[eps (1-eps)],[],prmk);
end

% Obtain city population and credit costs
popcred = popcredcost(rvar.kappa,prmk);
rvar.n = popcred.n;
rvar.Z = popcred.Z;
rvar.Kbar = popcred.Kbar;

end
