// Dynare script to solve for the dynamics of the model

// Declare parameters
parameters r, rho, rhol, zetah, zetal, lambdah, lambdal, alphah, alphal;
parameters deltah, upsilono, upsilonl, etao, etal, mu, sig, xi, E, chi;
parameters D, Dl, Co, Ch, Ci, Cl, Cw, Fh, Fi, Fl, omegah, omegai, omegal, ell;

// Declare endogenous variables
var xh, XXh, yh, yl, UUo, BBh, UUl, BBl, HHubar, JJubar, Sigmah, Sigmal, Sigmai;
var pih, pil, PPh, PPi, RR, kappa, Z, Kbar, ii, ps, thetao, thetal, vo, vl;
var so, sl, SSo, SSh, SSi, SSl, nuhbar, mh, ml, uo, ul, qh, ql, bh, GG, g, a, n, NN;
var Tmh, Tso, Tsl, LLambdah, LLambdal, VVh, VVl, RRbar, HH, LL, WW, Omega, Omegaa;
var PPPi, PP, h, SSlo, pr, Tmhinv;

// Declare exogenous variables
varexo tauh, taui;

// Set the length of a discrete time period
ell = 1/365; // Daily frequency

// Perform calibration and set parameters if no parameters already provided
if ~exist('prm','var')
    tgt = targets();
    prm = calibration(tgt);
end

// Set default tax rate change if no other tax rates provided
if ~exist('taxnew','var')
    taxnew = [0.0285;0.0285];
end

// Set initial conditions, trim parameter structure, and set model coefficients
pt0 = prm.pt0;
taxold = [prm.tauh;prm.taui];
prm = rmfield(prm,{'tauh';'taui';'pt0'});
prmnam = fieldnames(prm);
for prmnum = 1:size(prmnam,1);
set_param_value(prmnam{prmnum},eval(['prm.' prmnam{prmnum}]));
end

// Model equations, with references to where these occur in the paper
model;
#omegash = omegah/(1 + tauh*(1-omegah)); // equation (28)
#omegasi = omegai/(1 + taui*(1-omegai)); // equation (34)
(r + rho + alphah)*HHubar - ((HHubar(+1) - HHubar)/ell) = alphah*BBh + (rho + alphah)*UUo + g - D; // equation (A.3)
xh = (r + rho + alphah)*(BBh + UUo - HHubar); // equation (A.4)
yh = xh + (r + rho + alphah)*( Ch + (1+tauh)*Co + tauh*UUo ); // equation (A.6)
(r + rho)*BBh - ((BBh(+1) - BBh)/ell) = (1-omegash)*vo*Sigmah + g - Fh; // equation (A.7)
r*UUo - ((UUo(+1) - UUo)/ell) = thetao*vo*( omegash*(1-ps)*Sigmah + omegasi*ps*Sigmai ) - D; // equation (A.8)
((XXh(+1)-XXh)/ell) = (( r + rho + alphah*(1 - (deltah^lambdah)))/(lambdah-1))*( ((xh/XXh)^(1-lambdah)) - 1 )*XXh; // equation (A.16)
Sigmah = (1/((1 + tauh*omegash)*(lambdah-1)*(r + rho + alphah)))*( yh*((zetah/yh)^lambdah) + (alphah/(r + rho + alphah*(1 - (deltah^lambdah))))*( XXh*((zetah*deltah/XXh)^lambdah) ) ); // equation (A.17)
PPh = Co + UUo + omegash*(Sigmah/pih); // equation (30)
PPi = Co + UUo + omegasi*Sigmai; // equation (34)
GG = tauh*PPh*SSh + taui*PPi*SSi; // equation (26)
g = GG/n; // equation (26)
Sigmai = (UUl - (1+taui)*UUo - (1+taui)*Co - Ci)/(1 + taui*omegasi); // equation (38)
Fi = (1-omegasi)*vo*Sigmai; // equation (38)
(r + rho + alphal + rhol)*JJubar = (alphal + rhol)*BBl + (rho + alphal)*UUl + rhol*UUo + g - D - Dl + xi*(alphal + rhol)*kappa*(Z - Kbar) + ((JJubar(+1)-JJubar)/ell); // equation (A.26)
Sigmal = yl*((zetal/yl)^lambdal)/((lambdal-1)*(r + rho + alphal + rhol)); // equation (A.29)
yl = (r + rho + alphal + rhol)*(BBl + UUl - JJubar + Cl + Cw); // equation (A.28)
(r + rhol)*UUl - ((UUl(+1)-UUl)/ell) = omegal*thetal*vl*Sigmal - D + rhol*UUo; // equation (A.30)
(r + rho)*BBl - ((BBl(+1)-BBl)/ell) = (1-omegal)*vl*Sigmal + g - Fl; // equation (A.31)
RR = Dl + omegal*(r + rho + alphal + rhol)*(Cl + Cw) + omegal*(r + rho + alphal + rhol + thetal*vl*pil)*(Sigmal/pil) + (omegal/(r + rho + alphal + rhol))*((yl(+1) - yl)/ell); // equation (A.33)
NN = (1 - kappa)*BBl + kappa*(BBh - Kbar) - E; // equation (5)
a = rho*n + chi*NN; // equation (6)
((nuhbar - nuhbar(-1))/ell) + (rho + alphah*(1 - (deltah^lambdah)))*nuhbar = (rho + alphah*(1 - (deltah^lambdah)))*(1-ps)*thetao*vo*uo; // equations (A.18) and (A.22)
mh = alphah - (alphah*((zetah*deltah/xh)^lambdah)*nuhbar)/((rho + alphah*(1 - (deltah^lambdah)))*qh); // equation (A.23)
ml = alphal + rhol; // equation (8)
pih = (zetah/yh)^lambdah; // equation (40)
pil = (zetal/yl)^lambdal; // equation (40)
Z = BBh - BBl; // equation (3)
Kbar = exp(mu + (sig^2)/2)*normcdf((log(Z) - mu - (sig^2))/sig)/normcdf((log(Z) - mu)/sig); // equation (42)
kappa = normcdf((log(Z) - mu)/sig); // equations (4) and (42)
ii = ps/(ps + (1-ps)*pih); // equation (35)
vo = upsilono*(thetao^(-etao)); // equation (43)
vl = upsilonl*(thetal^(-etal)); // equation (43)
(1 - ps)*thetao = bh/uo; // equations (23) and (24)
((1-ps)*thetao - 1)*uo + (thetal - 1)*ul = n - 1; // equation (A.35)
so = thetao*vo*( ps + (1-ps)*pih ); // equation (36)
sl = thetal*vl*pil; // equation (17)
SSo = so*uo; // equation (36)
SSh = (1-ii)*SSo; // equation (36)
SSi = ii*SSo; // equation (36)
SSl = sl*ul; // equation (17)
((uo - uo(-1))/ell) = (mh + rho)*qh + rhol*(ql + ul) - so*uo; // equation (39)
((ul - ul(-1))/ell) = (alphal + rho)*ql + ii*so*uo - (sl + rhol)*ul; // equation (20)
((qh - qh(-1))/ell) = (1-ii)*so*uo - (mh + rho)*qh; // equation (22)
((ql - ql(-1))/ell) = sl*ul - (alphal + rhol + rho)*ql; // equation (18)
((bh - bh(-1))/ell) = mh*qh + (xi*(alphal + rhol)*ql + a)*kappa - (vo*pih + rho)*bh; // equations (4) and (31)
((n - n(-1))/ell) = a - rho*n; // equation (6)
Tmh = 1/(mh + rho); // definition of time between moves
Tso = 1/so; // definition of time to sell
Tsl = 1/sl; // definition of time to lease
LLambdah = 1/pih; // definition of viewings per home-buyer purchase
LLambdal = 1/pil; // definition of viewings per lease
((VVh - VVh(-1))/ell) = ((1-ii)*so*uo/qh)*( (lambdah/(lambdah-1))*yh - VVh ) - (alphah - mh)*(VVh - (lambdah/(lambdah-1))*xh ); // equation (45)
((VVl - VVl(-1))/ell) = (sl*ul*ql)*( (lambdal/(lambdal-1))*yl - VVl ); // equation (46)
RRbar = RR + omegal*( VVl - (lambdal/(lambdal-1))*yl ); // equation (A.34)
r*HH = VVh + g - D - mh*(HH - BBh - UUo) - rho*(HH - UUo) - (pih*vo*bh/qh)*( Ch + BBh + (1+tauh)*(Co + UUo) + (1 + tauh*omegash)*(Sigmah/pih) - HH ) + ((HH(+1) - HH)/ell); // equation (A.40)
r*LL = RRbar - D - Dl - (alphal + rho)*(LL - UUl) - rhol*(LL - UUo) - (pil*vl*thetal*ul/ql)*( UUl + omegal*( Cl + Cw ) + omegal*(Sigmal/pil) - LL ) + ((LL(+1) - LL)/ell); // equation (A.43)
r*WW = VVl + g - RRbar - (1-xi)*ml*(WW - BBl) - xi*ml*(WW - kappa*(BBh - Kbar) - (1-kappa)*BBl ) - rho*WW - (pil*ql*thetal*ul/ql)*( BBl + (1-omegal)*(Cl + Cw) + (1-omegal)*(Sigmal/pil) - WW ) + ((WW(+1) - WW)/ell); // equation (A.42)
r*Omegaa = a*NN + ((Omegaa(+1) - Omegaa)/ell); // defined above equation (44)
r*Omega = qh*VVh + ql*VVl - D - Dl*ql - Fh*bh - Fi*ps*thetao*uo - Fl*thetal*ul - ((1-ii)*Ch + ii*Ci + Co)*SSo - (Cl + Cw)*SSl - (xi*(alphal+rhol)*ql + a)*kappa*Kbar - a*E + ((Omega(+1) - Omega)/ell); // equation (44)
r*PPPi = GG + ((PPPi(+1) - PPPi)/ell); // definition of present value of tax revenue
PP = ii*PPi + (1-ii)*PPh; // definition of average price
h = (qh + bh)/n; // equation (2)
SSlo = SSl/SSo; // definition of leases-to-sales ratio
pr = PPi/RR; // definition of price-to-rent ratio
Tmhinv = 1/Tmh; // definition of owners' moving rate
end;

// Initial steady-state values at old tax rates
initval;
tauh = taxold(1);
taui = taxold(2);
ps = pt0(1);
thetao = pt0(2);
end;
steady;

// Terminal steady-state values at new tax rates
endval;
tauh = taxnew(1);
taui = taxnew(2);
ps = pt0(1);
thetao = pt0(2);
end;
steady;

// Perfect-foresight simulation of transitional path
perfect_foresight_setup(periods=33600);
perfect_foresight_solver;
