function [endo,params,check] = rentown_steadystate(endoinit,exo,M_,options_)
% This is called by Dynare to solve for the steady state of the model

disp('Starting steady-state solver...');

% Extract model parameters
prm = cell2struct(table2cell(array2table(M_.params)),M_.param_names);
prm = rmfield(prm,'ell');

% Set exogenous variables as parameters for steady state
prm = setfield(prm,M_.exo_names{1},exo(1));
prm = setfield(prm,M_.exo_names{2},exo(2));

% Set initial values of endogenous variables for numerical search
prm.pt0 = [endoinit(find(strcmp(M_.endo_names,'ps'))); ...
    endoinit(find(strcmp(M_.endo_names,'thetao')))];

% Create blank vector of endogenous variables and copy over parameter vector
endo = zeros(size(M_.endo_names));
params = M_.params;
check = 0;

% Obtain steady state numerically
res = predict(prm);
if ~isfield(res,'ps')
    check = 1;
    return;
end

% Return steady-state values
for varnum = 1:size(M_.endo_names,1)
    endo(varnum) = getfield(res,M_.endo_names{varnum});
end

end
