% Produce results table

% Variables to include in results table
vars = {'Tmhinv'   'Moving rate of owners       ';
        'SSh'      'Buy-to-own (BTO) sales      ';
        'SSi'      'Buy-to-rent (BTR) sales     ';
        'SSlo'     'Leases-to-sales ratio       ';
        'pr'       'Price-to-rent ratio         ';
        'PP'       'Average transactions price  ';
        'h'        'Homeownership rate          '};

% Change to tax rates
taxnew = [0.0285;0.0285];

% Get targets and calibrate parameters
tgt = targets();
matchregression;
prm = calibration(tgt);

% Number of years to average over
yrs = 4;

% Call Dynare
dynare rentown.mod;

% Find number of discrete time periods in one year
py = round(1/M_.params(find(strcmp(M_.param_names,'ell'))));

% Extract variable indices
vnum = size(vars,1);
vidx = zeros(vnum,1);
for v=1:vnum
    vidx(v) = find(strcmp(M_.endo_names,vars(v,1)));
end

% Get impulse response functions and average
imprss = oo_.endo_simul(vidx,end)';
impr = oo_.endo_simul(vidx,1:(1+py*yrs))';
resp = log(impr(2:end,:)) - ones(py*yrs,1)*log(impr(1,:));
avresp = mean(resp)';
ssresp = (log(imprss) - log(impr(1,:)))';

% Conversion to percentage points
avresp = 100*(exp(avresp) - 1);
ssresp = 100*(exp(ssresp) - 1);
hidx = find(strcmp(vars,'h'));
avresp(hidx) = impr(1,hidx)*avresp(hidx);
ssresp(hidx) = impr(1,hidx)*ssresp(hidx);

% Display results table
fprintf('Variable name                :  Average  ,  New steady state\n');
for v=1:vnum
    fprintf([vars{v,2} ' :   ' num2str(avresp(v),'%.1f') '%%   ,   ' num2str(ssresp(v),'%.1f') '%%\n']);
end
