function yh = solveownthres(prm)
% Find the transaction threshold for homeowners

% Check for existence of a solution
exists = ownthrescrit(prm.zetah,prm);
if (exists < 0)
    yh = NaN;
    return;
end

% Search numerically for a solution
[yh,~,exitflag] = fzero(@ownthrescrit,(prm.lambdah/(prm.lambdah-1))*prm.zetah,[],prm);

% Check return is valid
if (exitflag < 0)
    yh = NaN;
end

end
