function tgt = targets()
% Set baseline calibration targets

tgt = struct('n',1, ... % City population relative to housing stock
'chi',1, ... % Elasticity of population flows with respect to new-entrant value
'BBl',0, ... % No desire of households to exit city
'omegao_etao',1, ... % Ownership-market bargaining power relative to meeting function elasticity
'omegal_etal',1, ... % Rental-market bargaining power relative to meeting function elasticity
'Fh_vo_Y',0.5, ... % Home-buyer search cost, expressed as daily income cost per viewing
'LLambdal_LLambdah',0.5, ... % Average viewings by renters relative to viewings by home-buyers
'Fl_vl_Fh_vo',0.5, ... % Per-viewing rental search cost relative to per-viewing home-buyer search cost
'Fi_Fh',1, ... % Investor search cost relative to home-buyer search cost
'h',0.54, ... % Homeownership rate
'ii',0.05367, ... % Fraction of all purchases made by investors
'PPi_RR',14.5, ... % Price-to-rent ratio for investors
'PPi_PPh',0.9904, ... % Average price paid by investors relative to home-buyers
'phi',0.4, ... % Fraction of first-time buyers among all home-buyers
'aleph',53.3 - 45, ... % Average age difference between owner-occupiers and renters
'rg',0.0186, ... % Risk-free real interest rate
'rkbar',0.0493, ... % Average real mortgage interest rate
'rz',0.0643, ... % Real mortgage rate for marginal home-buyer
'l',0.8, ... % Initial mortgage loan-to-value ratio
'Tk',25, ... % Length of mortgage term
'Ch_PPh',0, ... % Non-tax home-buyer transaction cost relative to average price
'Ci_PPi',0, ... % Non-tax investor transaction cost relative to average price
'D_PP',0.026, ... % Property maintenance cost as a fraction of the average price
'Dl_RR',0.08, ... % Extra maintenance/management costs of landlords as a fraction of average rent
'Co_PP',0.045, ... % Sellers' transaction costs as a fraction of the average price
'Cl_RR',1/12, ... % Landlords' letting costs as a fraction of average annual rent
'A_Cl',0, ... % Fraction of landlords' costs passed on to tenants as key fee
'Tso',30.5/365/(1-0.4811), ... % Average time on the market for sellers
'Tbh',1.28*30.5/365/(1-0.4811), ... % Average time taken for home-buyers to make purchase
'Tsl',18.7/365/(1-0.2235), ... % Average time on the market for rental properties
'LLambdah',10.7/(1-0.4811), ... % Average number of properties viewed by home-buyers
'Tmh',9.25, ... % Average time between moves for owner-occupiers
'Tml',1109/365, ... % Average time between moves for tenants
'PPh_Y',5.6, ... % Price-income ratio for home-buyers
'PP',402, ... % Average house price over all transactions
'tauh',0.0154, ... % Initial transaction tax rate faced by home-buyers
'taui',0.0154, ... % Initial transaction tax rate faced by investors
'betamh',-0.13, ... % Response of log moving rate to tax change
'varkappa',0.128524443080717); % Sensitivity of moving rate to aggregate shocks

end
