clear
version 10.0
capture log close
set memory 40m
set scheme s1mono

use swingvoters.dta

********************
*** Prepare Data ***
********************

gen testso=dem_minus_rep_south/pct_swing_south

gen phi=3.02/0.4

gen kappaso=-testso/phi

gen testnso=dem_minus_rep_nonsouth/pct_swing_nonsouth

gen kappanso=-testnso/phi

label var kappaso "South"

label var kappanso "Non-South"

label var year "year"

****************
*** Figure 2 ***
****************

# delimit ;
scatter kappaso kappanso year, title("Figure 2 - Political Competition Calibrated from NES Surveys", margin(medsmall) size(medium))
ytitle("Political Competition", margin(small) size(medsmall)) 
xtitle("Year", margin(small) size(medsmall))
msymbol(triangle_hollow square_hollow) msize(medium medium) mcolor(black black)
connect(l l)
note("Note: The graph displays the results of a calibration of our theoretical measure of political competition"
"for states in the US south and north using the biannual National Election Studies (NES) data. See"
"the main text for details of the calibration.", size(small));


# delimit cr

graph export results\Figure2.eps, replace as(eps)

exit

