clear
version 10.0
set more off
capture log close
set memory 80m
set matsize 800


log using logs\bps-main-regressions.log, replace

use uscomp.dta

*********************
*** Select Sample ***
*********************

drop if year<1929 

/* All tables with the exception of Table 7 focus on the post 1929 sample */

*************************************
*** Generate Auxilliary Variables ***
*************************************

** Define a numeric state identifier and declare panel structure **

egen stcode = group(state)
tsset stcode year 

** Create log incomes and growth rates **

gen stinc = inc*1000/pop
replace stinc=stinc*100/index
gen lstinc = log(stinc)  
sort state year
by state: gen llstinc = lstinc[_n-1]
gen gstinc = lstinc-llstinc

** Generate state and time dummies **

quietly tab year, gen(yy) 
quietly tab state, gen(stdum)  

** Generate south year interactions **

/* Automatically detect length of panel */

sort year
gen temp=year if _n==1
egen minyear=max(temp)
drop temp

gsort -year
gen temp=year if _n==1
egen maxyear=max(temp)
drop temp

gen panel=maxyear-minyear+1

local i=1
while `i' <= panel {
gen soyy`i'=so*yy`i'
local i =`i'+1
}

** Generate the measures of Democratic or Republican control over the state houses **

gen demcontrol=0
replace demcontrol=1 if(uhd/uht>0.5)&(lhd/lht>0.5)

gen repcontrol=0
replace repcontrol=1 if(uhr/uht>0.5)&(lhr/lht>0.5)

** Generate the core IV **

gen core=0
replace core=PT if (state=="Alabama"|state=="Mississippi"|state=="Texas"|state=="Virginia")
replace core=LT if (state=="Georgia"|state=="Louisiana"|state=="South Carolina"|state=="North Carolina"|state=="Arizona")

** Split the compnorm measure into a measure for Republicans and Democrats **

gen demcomp=compnorm*gip
gen repcomp=compnorm
replace repcomp=0 if gip==1
replace repcomp=. if gip==.  

/* Note that this step does not matter as long as gip is included in the regression */

** Generate dummies for different ranges of political competiton **

gen com1=0
replace com1=1 if compnorm>-0.10
gen com2=0
replace com2=1 if compnorm>=-0.25
gen com3=0
replace com3=1 if compnorm>=-0.40

/* Number of obs in our base category */
count if com3==0&com2==0&com1==0

/* Number of obs in the next category up */
count if com3==1&com2==0&com1==0

/* Number of obs in the -0.25 to -0.10 category */
count if com2==1&com1==0

/* Number of obs in category with the highest competition (above -0.10) */
count if com1==1

** Generate the policy variables **

gen share_taxes_inc=total_taxes*100/inc
gen share_cap_exp=total_capital*100/total_exp

** Generate the non farm share **

gen  non_farm_share=non_farm_inc/(non_farm_inc+farm_inc)


********************************************
*** Final variable labels for the tables ***
********************************************

label variable share_taxes_inc "Taxes as a share of state income" 
label variable share_cap_exp "Capital outlays as a percent of total state gen. expenditure"
label variable lstinc "Personal income"
label variable llstinc "Lagged personal income"
label variable PT "Poll taxes"
label variable compnorm "Political competition"
label variable LT "Literacy tests"
label variable gstinc "Growth of peronal income"
label variable rtw "Right-to-Work laws"


*********************
*** Table 1 Means ***
*********************

** All states **

sum compnorm gip demcontrol repcontrol normdem gstinc share_taxes_inc share_cap_exp rtw non_farm_share 

** South and North separately **

sort so

by so: sum compnorm gip demcontrol repcontrol normdem gstinc share_taxes_inc share_cap_exp rtw non_farm_share 


*********************************
*** Table 2  Impact on Policy ***
*********************************

** taxation **

reg share_taxes_inc compnorm yy* stdum2-stdum48 , cluster(stcode) 
outreg compnorm using results\Table_2.out, se coefastr 10pct sigsymb(***,**,*)  rdec(3) bdec(3) r2 nocons replace

reg share_taxes_inc compnorm soyy* yy* stdum2-stdum48 , cluster(stcode) 
outreg compnorm using results\Table_2.out, se coefastr 10pct sigsymb(***,**,*)  rdec(3) bdec(3) r2 nocons append

reg compnorm core yy* stdum2-stdum48 if share_taxes_inc~=., cluster(stcode) 
test core

ivreg share_taxes_inc (compnorm=core) yy* stdum2-stdum48 , cluster(stcode) 
outreg compnorm using results\Table_2.out, se coefastr 10pct sigsymb(***,**,*)  rdec(3) bdec(3) r2 nocons append

** capital expenditure **

reg share_cap_exp compnorm  yy* stdum2-stdum48 , cluster(stcode) 
outreg compnorm using results\Table_2.out, se coefastr 10pct sigsymb(***,**,*)  rdec(3) bdec(3) r2 nocons append

reg share_cap_exp compnorm soyy* yy* stdum2-stdum48 , cluster(stcode) 
outreg compnorm using results\Table_2.out, se coefastr 10pct sigsymb(***,**,*)  rdec(3) bdec(3) r2 nocons append

reg compnorm core yy* stdum2-stdum48  if share_cap_exp~=., cluster(stcode) 
test core

ivreg share_cap_exp (compnorm=core) yy* stdum2-stdum48 , cluster(stcode) 
outreg compnorm using results\Table_2.out, se coefastr 10pct sigsymb(***,**,*)  rdec(3) bdec(3) r2 nocons append

** right to work laws **

reg rtw compnorm  yy* stdum2-stdum48 , cluster(stcode) 
outreg compnorm using results\Table_2.out, se coefastr 10pct sigsymb(***,**,*)  rdec(3) bdec(3) r2 nocons append

reg rtw compnorm soyy* yy* stdum2-stdum48 , cluster(stcode) 
outreg compnorm using results\Table_2.out, se coefastr 10pct sigsymb(***,**,*)  rdec(3) bdec(3) r2 nocons append

reg compnorm core yy* stdum2-stdum48  if rtw~=., cluster(stcode) 
test core

ivreg rtw (compnorm=core) yy* stdum2-stdum48 , cluster(stcode) 
outreg compnorm using results\Table_2.out, se coefastr 10pct sigsymb(***,**,*)  rdec(3) bdec(3) r2 nocons append


****************************************************************************
*** Table 3  Policy Additonal Results: Party Effects and Non-Linearities ***
****************************************************************************

** taxtion **

reg share_taxes_inc compnorm gip demcontrol repcontrol soyy* yy* stdum2-stdum48 , cluster(stcode) 
outreg compnorm gip demcontrol repcontrol using results\Table_3.out, se coefastr 10pct sigsymb(***,**,*)  rdec(3) bdec(3) r2 nocons replace

reg share_taxes_inc compnorm gip demcontrol repcontrol normdem soyy* yy* stdum2-stdum48 , cluster(stcode) 
outreg compnorm gip demcontrol repcontrol normdem using results\Table_3_add.out, se coefastr 10pct sigsymb(***,**,*)  rdec(3) bdec(3) r2 nocons replace

reg share_taxes_inc demcomp repcomp gip demcontrol repcontrol soyy* yy* stdum2-stdum48 , cluster(stcode) 
outreg demcomp repcomp gip demcontrol repcontrol using results\Table_3.out, se coefastr 10pct sigsymb(***,**,*)  rdec(3) bdec(3) r2 nocons append
test repcomp=demcomp

reg share_taxes_inc com1 com2 com3 gip demcontrol repcontrol normdem soyy* yy* stdum2-stdum48 , cluster(stcode) 
outreg com1 com2 com3 gip demcontrol repcontrol normdem using results\Table_3_add.out, se coefastr 10pct sigsymb(***,**,*)  rdec(3) bdec(3) r2 nocons append

** capital expenditure **

reg share_cap_exp compnorm gip demcontrol repcontrol soyy* yy* stdum2-stdum48 , cluster(stcode) 
outreg compnorm demcontrol repcontrol gip using results\Table_3.out, se coefastr 10pct sigsymb(***,**,*)  rdec(3) bdec(3) r2 nocons append

reg share_cap_exp compnorm gip demcontrol repcontrol normdem soyy* yy* stdum2-stdum48 , cluster(stcode) 
outreg compnorm demcontrol repcontrol gip normdem using results\Table_3_add.out, se coefastr 10pct sigsymb(***,**,*)  rdec(3) bdec(3) r2 nocons append

reg share_cap_exp repcomp demcomp gip demcontrol repcontrol soyy* yy* stdum2-stdum48 , cluster(stcode) 
outreg demcontrol repcontrol gip repcomp demcomp using results\Table_3.out, se coefastr 10pct sigsymb(***,**,*)  rdec(3) bdec(3) r2 nocons append
test repcomp=demcomp

reg share_cap_exp com1 com2 com3 gip demcontrol repcontrol normdem soyy* yy* stdum2-stdum48 , cluster(stcode) 
outreg demcontrol repcontrol gip com1 com2 com3 normdem using results\Table_3_add.out, se coefastr 10pct sigsymb(***,**,*)  rdec(3) bdec(3) r2 nocons append

** right to work laws **

reg rtw compnorm gip demcontrol repcontrol soyy* yy* stdum2-stdum48 , cluster(stcode) 
outreg compnorm gip demcontrol repcontrol using results\Table_3.out, se coefastr 10pct sigsymb(***,**,*)  rdec(3) bdec(3) r2 nocons append

reg rtw compnorm gip demcontrol repcontrol normdem soyy* yy* stdum2-stdum48 , cluster(stcode) 
outreg compnorm gip demcontrol repcontrol normdem using results\Table_3_add.out, se coefastr 10pct sigsymb(***,**,*)  rdec(3) bdec(3) r2 nocons append

reg rtw repcomp demcomp gip demcontrol repcontrol soyy* yy* stdum2-stdum48 , cluster(stcode) 
outreg repcomp demcomp gip demcontrol repcontrol using results\Table_3.out, se coefastr 10pct sigsymb(***,**,*)  rdec(3) bdec(3) r2 nocons append
test repcomp=demcomp

reg rtw com1 com2 com3 gip demcontrol repcontrol normdem soyy* yy* stdum2-stdum48 , cluster(stcode) 
outreg com1 com2 com3 gip demcontrol repcontrol normdem using results\Table_3_add.out, se coefastr 10pct sigsymb(***,**,*)  rdec(3) bdec(3) r2 nocons append

************************************************************
*** Table 3 Appendix: Further discussed in the main text ***
************************************************************

** Adding a southern Democrat dummy for both governor and state house control **

gen dem_so=demcontrol*so
gen gip_so=gip*so
gen norm_so=normdem*so

reg share_taxes_inc compnorm gip demcontrol repcontrol normdem gip_so dem_so norm_so soyy* yy* stdum2-stdum48 , cluster(stcode) 

reg share_cap_exp compnorm gip demcontrol repcontrol normdem gip_so dem_so norm_so soyy* yy* stdum2-stdum48 , cluster(stcode) 

reg rtw compnorm gip demcontrol repcontrol normdem gip_so dem_so norm_so soyy* yy* stdum2-stdum48 , cluster(stcode) 

** The dummy specifications without the political control variables **

reg share_taxes_inc com1 com2 com3 soyy* yy* stdum2-stdum48 , cluster(stcode) 

reg share_cap_exp com1 com2 com3 soyy* yy* stdum2-stdum48 , cluster(stcode) 

reg rtw com1 com2 com3 soyy* yy* stdum2-stdum48 , cluster(stcode) 


**********************************************************************
*** Table 4: Policy Additional Results: North, South and Averaging ***
**********************************************************************

** South **

reg share_taxes_inc compnorm gip demcontrol repcontrol yy* stdum2-stdum48 if so==1, cluster(stcode) 
outreg compnorm gip demcontrol repcontrol using results\Table_4.out, se coefastr 10pct sigsymb(***,**,*)  rdec(3) bdec(3) r2 nocons replace

reg share_cap_exp compnorm gip demcontrol repcontrol yy* stdum2-stdum48 if so==1, cluster(stcode) 
outreg compnorm gip demcontrol repcontrol using results\Table_4.out, se coefastr 10pct sigsymb(***,**,*)  rdec(3) bdec(3) r2 nocons append

reg rtw compnorm gip demcontrol repcontrol yy* stdum2-stdum48 if so==1, cluster(stcode) 
outreg compnorm gip demcontrol repcontrol using results\Table_4.out, se coefastr 10pct sigsymb(***,**,*) rdec(3) bdec(3) r2 nocons append


** North **

reg share_taxes_inc compnorm gip demcontrol repcontrol yy* stdum2-stdum48 if so==0, cluster(stcode) 
outreg compnorm gip demcontrol repcontrol using results\Table_4.out, se coefastr 10pct sigsymb(***,**,*)  rdec(3) bdec(3) r2 nocons append

reg share_cap_exp compnorm gip demcontrol repcontrol yy* stdum2-stdum48 if so==0, cluster(stcode) 
outreg compnorm gip demcontrol repcontrol using results\Table_4.out, se coefastr 10pct sigsymb(***,**,*)  rdec(3) bdec(3) r2 nocons append

reg rtw compnorm gip demcontrol repcontrol yy* stdum2-stdum48 if so==0, cluster(stcode) 
outreg compnorm gip demcontrol repcontrol using results\Table_4.out, se coefastr 10pct sigsymb(***,**,*)  rdec(3) bdec(3) r2 nocons append


** Five Year Averages in the Policy Regressions **

save temp\temp_five_year.dta, replace

/* Generate five year averages */

drop if year<1930
drop if year>1999

gen fiveyear=.

local k=1930
local i=1934
local j=1

while `i' < 2005 {
replace fiveyear=`j' if (year<=`i'&year>=`k')
local i = `i' + 5
local k = `k' + 5
local j = `j' + 1
}

encode state, gen(stateid)

keep stateid year share* rtw normdem compnorm core so demcontrol repcontrol gip fiveyear

collapse (mean) year share* rtw normdem compnorm core so demcontrol repcontrol gip, by (stateid fiveyear)

quietly tab stateid, gen(stdum)
quietly tab year, gen(yy)

local i=1
while `i' <=14 {
gen soyy`i'=so*yy`i'
local i =`i'+1
}

reg share_taxes_inc compnorm gip demcontrol repcontrol soyy* yy* stdum2-stdum48 , cluster(stateid) 
outreg compnorm gip demcontrol repcontrol using results\Table_4_add.out, se coefastr 10pct sigsymb(***,**,*)  rdec(3) bdec(3) r2 nocons replace

reg share_cap_exp compnorm gip demcontrol repcontrol soyy* yy* stdum2-stdum48 , cluster(stateid) 
outreg compnorm gip demcontrol repcontrol using results\Table_4_add.out, se coefastr 10pct sigsymb(***,**,*)  rdec(3) bdec(3) r2 nocons append

reg rtw compnorm gip demcontrol repcontrol soyy* yy* stdum2-stdum48 , cluster(stateid) 
outreg compnorm gip demcontrol repcontrol using results\Table_4_add.out, se coefastr 10pct sigsymb(***,**,*)  rdec(3) bdec(3) r2 nocons append


****************************************
*** Table 5  Basic Results on Growth ***
****************************************

use temp\temp_five_year.dta, replace

** Column 1: Basic OLS **

reg gstinc compnorm llstinc yy* stdum2-stdum48, cluster(stcode) 
outreg compnorm llstinc using results\Table_5.out, se coefastr 10pct sigsymb(***,**,*)  rdec(3) bdec(3) r2 nocons replace

** Column 2: OLS with south year interactions **

reg gstinc compnorm llstinc soyy* yy* stdum2-stdum48, cluster(stcode) 
outreg compnorm llstinc using results\Table_5.out, se coefastr 10pct sigsymb(***,**,*)  rdec(3) bdec(3) r2 nocons append

** Column 3: Instrumenting with core without south year interactions **
reg compnorm core llstinc yy* stdum2-stdum48, cluster(state)
test core

ivreg gstinc (compnorm=core) llstinc yy* stdum2-stdum48, cluster(stcode) 
outreg compnorm llstinc using results\Table_5.out, se coefastr 10pct sigsymb(***,**,*)  rdec(3) bdec(3) r2 nocons append

** Column 4: Instrumenting with core with south year interactions **
reg compnorm core llstinc soyy* yy* stdum2-stdum48, cluster(state)
test core

ivreg gstinc (compnorm=core) llstinc soyy* yy* stdum2-stdum48, cluster(stcode) 
outreg compnorm llstinc using results\Table_5.out, se coefastr 10pct sigsymb(***,**,*)  rdec(3) bdec(3) r2 nocons append


*****************************************
*** Table 6 Further Results on Growth ***
*****************************************

** Column 1: Control of state house and senate **

reg gstinc compnorm gip demcontrol repcontrol llstinc soyy* yy* stdum* , cluster(stcode) 
outreg compnorm gip demcontrol repcontrol llstinc using results\Table_6.out, se coefastr 10pct sigsymb(***,**,*)  rdec(3) bdec(3) r2 nocons replace

** Column 2: Control of state house and senate and Democratic Vote Share **

reg gstinc compnorm gip demcontrol repcontrol normdem llstinc soyy* yy* stdum* , cluster(stcode) 
outreg compnorm gip demcontrol repcontrol normdem llstinc using results\Table_6.out, se coefastr 10pct sigsymb(***,**,*)  rdec(3) bdec(3) r2 nocons append

** Column 3: Separte measure of competition for Democrats and Republicans **

reg gstinc demcomp repcomp gip demcontrol repcontrol llstinc soyy* yy* stdum2-stdum48 , cluster(stcode) 
outreg demcomp repcomp gip demcontrol repcontrol llstinc using results\Table_6.out, se coefastr 10pct sigsymb(***,**,*)  rdec(3) bdec(3) r2 nocons append
test demcomp=repcomp

** Column 4: Turning compnorm into dummies **

reg gstinc com1 com2 com3 gip demcontrol repcontrol normdem llstinc  soyy* yy3-yy73 stdum2-stdum48, cluster(stcode)
outreg com1 com2 com3 gip demcontrol repcontrol normdem llstinc using results\Table_6.out, se coefastr 10pct sigsymb(***,**,*)  rdec(3) bdec(3) r2 nocons append

** Column 5: Only Southern states **

reg gstinc compnorm gip demcontrol repcontrol llstinc yy* stdum* if so==1, cluster(stcode) 
outreg compnorm gip demcontrol repcontrol llstinc using results\Table_6.out, se coefastr 10pct sigsymb(***,**,*)  rdec(3) bdec(3) r2 nocons append

** Column 6: Only Northern states **

reg gstinc compnorm gip demcontrol repcontrol llstinc yy* stdum* if so==0, cluster(stcode) 
outreg compnorm gip demcontrol repcontrol llstinc using results\Table_6.out, se coefastr 10pct sigsymb(***,**,*)  rdec(3) bdec(3) r2 nocons append

** Column 9: share of non farm income OLS **

reg non_farm_share compnorm gip demcontrol repcontrol soyy* yy* stdum2-stdum48 , cluster(state)
outreg compnorm gip demcontrol repcontrol using results\Table_6.out, se coefastr 10pct sigsymb(***,**,*)  rdec(3) bdec(3) r2 nocons append

** Columns 8 and 9 which require averaging **

/* Generate five year averages */

drop if year<1930
drop if year>1999

gen fiveyear=.

local k=1930
local i=1934
local j=1

while `i' < 2005 {
replace fiveyear=`j' if (year<=`i'&year>=`k')
local i = `i' + 5
local k = `k' + 5
local j = `j' + 1
}

encode state, gen(stateid)

keep stateid year stinc compnorm core so demcontrol repcontrol gip fiveyear

collapse (mean) year stinc compnorm core so demcontrol repcontrol gip, by (stateid fiveyear)

gen lstinc=log(stinc)

quietly tab stateid, gen(stdum)
quietly tab year, gen(yy)

sort stateid year
by stateid: gen llstinc = lstinc[_n-1]
by stateid: gen lag_stinc = stinc[_n-1]

gen gstinc = lstinc-llstinc

local i=1
while `i' <=14 {
gen soyy`i'=so*yy`i'
local i =`i'+1
}

tsset stateid fiveyear 

** Columns 7 : Five year averages **

reg gstinc compnorm gip demcontrol repcontrol llstinc soyy* yy* stdum2-stdum48, cluster(stateid) 
outreg compnorm gip demcontrol repcontrol llstinc using results\Table_6.out, se coefastr 10pct sigsymb(***,**,*)  rdec(3) bdec(3) r2 nocons append

** Column 8 : Arellano Bond (treating compnorm as predetermined) **

xtabond gstinc llstinc demcontrol repcontrol gip soyy* yy* stdum*, maxldep(1) maxlags(1) pre(compnorm) robust


******************************************
*** Table 7 Growth during 1880 to 1920 ***
******************************************

use uscomp.dta, clear

*** Generate the Measures of Dem and Rep control ***

gen demcontrol=0
replace demcontrol=1 if(uhd/uht>0.5)&(lhd/lht>0.5)

gen repcontrol=0
replace repcontrol=1 if(uhr/uht>0.5)&(lhr/lht>0.5)

replace repcontrol=. if uht==.|lht==.
replace demcontrol=. if uht==.|lht==.

/* There are two missings which create a problem with the code 
   for repcontrol just above which we fix here */

replace repcontrol=0 if state=="Virginia"&year==1924
replace repcontrol=0 if state=="Virginia"&year==1925

*** Generate core for early years ***

* Generate core for early years

gen core=0
replace core=PT if (state=="Alabama"|state=="Mississippi"|state=="Texas"|state=="Virginia")
replace core=LT if (state=="Georgia"|state=="Louisiana"|state=="South Carolina"|state=="North Carolina"|state=="Arizona")

*** Generate Averages of Variables ***

gen temp=0
replace temp=1 if year>1880&year<=1900
replace temp=2 if year>1900&year<=1920
replace temp=3 if year>1920&year<=1950
replace temp=4 if year>1950

sort state temp
egen m_compnorm=mean(compnorm), by(state temp)
egen m_PT=mean(PT), by(state temp)
egen m_LT=mean(LT), by(state temp)
egen m_dem=mean(demcontrol), by(state temp)
egen m_rep=mean(repcontrol), by(state temp)
egen m_core=mean(core), by(state temp)
egen m_gip=mean(gip), by(state temp)

egen m_normdem=mean(normdem), by(state temp)

replace compnorm=m_compnorm
replace PT=m_PT
replace LT=m_LT
replace demcontrol=m_dem
replace repcontrol=m_rep
replace core=m_core
replace gip=m_gip

replace normdem=m_normdem

drop m_*
drop temp

*** Regressions for the Easterlin sample ***

keep if year==1880|year==1900|year==1920|year==1950

tab year, gen(yy)

** Generate anualized growth rates **

sort state year
quietly by state: gen lagyear=year[_n-1]
quietly by state: gen length=year-lagyear

sort state year
quietly by state: gen lag_early_inc=early_inc[_n-1]

gen gearly_inc=((early_inc/lag_early_inc)^(1/length)-1)

** log and lag of income **

sort state year
gen learly_inc=log(early_inc)
quietly by state: gen lag_learly_inc=learly_inc[_n-1]

** Generate initial income **

sort state year
gen temp=early_inc if year==1880
egen initial_early_inc=max(temp), by(state)
gen linitial_early_inc=log(initial_early_inc)
drop temp

*** Additional Variables ***

* South year interactions

gen soyy2=yy2*so
gen soyy3=yy3*so
gen soyy4=yy4*so

*** Growth regressions for the 1880, 1900 and 1920 sample ***

drop if year==1950

**** Cross-sections ****

reg gearly_inc compnorm lag_learly_inc if year==1900, robust
reg gearly_inc compnorm lag_learly_inc if year==1920, robust

*** Pooling with time dummies full sample ****

*** Column 1: OLS ***

reg gearly_inc compnorm lag_learly_inc yy3 yy4, cluster(state)
outreg compnorm lag_learly_inc using results\Table_7.out, se coefastr 10pct sigsymb(***,**,*) rdec(3) bdec(3) r2 nocons replace

*** Column 2: OLS and south year interactions ***

reg gearly_inc compnorm lag_learly_inc so soyy3 soyy4 yy3 yy4, cluster(state)
outreg compnorm lag_learly_inc using results\Table_7.out, se coefastr 10pct sigsymb(***,**,*) rdec(3) bdec(3) r2 nocons append

*** Columns 3: party control ***

sum gip, 
replace gip=. if year==1880
gen temp=0
replace temp=1 if gip>=0.5&gip~=.
replace temp=. if gip==.

gen demcomp=compnorm*temp
gen repcomp=compnorm
replace repcomp=0 if temp==1
replace repcomp=. if temp==.  /* Note that this step does not matter as long as gip is included in the regression */

reg gearly_inc compnorm gip demcontrol repcontrol lag_learly_inc so soyy3 soyy4 yy3 yy4, cluster(state)
outreg compnorm gip demcontrol repcontrol lag_learly_inc using results\Table_7.out, se coefastr 10pct sigsymb(***,**,*)  rdec(3) bdec(3) r2 nocons append

*** Column 4: Party control and the Democratic vote share ***

reg gearly_inc compnorm gip demcontrol repcontrol normdem lag_learly_inc so soyy3 soyy4 yy3 yy4, cluster(state)
outreg compnorm gip demcontrol repcontrol normdem lag_learly_inc using results\Table_7.out, se coefastr 10pct sigsymb(***,**,*)  rdec(3) bdec(3) r2 nocons append

*** Column 5: Democratic and Republican separately ***

reg gearly_inc demcomp repcomp gip demcontrol repcontrol lag_learly_inc so soyy3 soyy4 yy3 yy4, cluster(state)
outreg demcomp repcomp gip demcontrol repcontrol lag_learly_inc using results\Table_7.out, se coefastr 10pct sigsymb(***,**,*)  rdec(3) bdec(3) r2 nocons append
test demcomp=repcomp

*** Columns 6 and 7: South and North separately ***

reg gearly_inc compnorm gip demcontrol repcontrol lag_learly_inc yy3 yy4 if so==1, cluster(state)
outreg compnorm gip demcontrol repcontrol lag_learly_inc using results\Table_7.out, se coefastr 10pct sigsymb(***,**,*)  rdec(3) bdec(3) r2 nocons append

reg gearly_inc compnorm gip demcontrol repcontrol lag_learly_inc yy3 yy4 if so==0, cluster(state)
outreg compnorm gip demcontrol repcontrol lag_learly_inc using results\Table_7.out, se coefastr 10pct sigsymb(***,**,*)  rdec(3) bdec(3) r2 nocons append

log close 
exit
