clear
version 10.0
set more off
capture log close
set mem 80m
set matsize 800
set scheme s1mono


use uscomp.dta

*********************
*** Select Sample ***
*********************

drop if year<1880
drop if year>1999

**********************************
*** Generate ten year averages ***
**********************************

keep state year compnorm so ne mw we

gen region=0
replace region=1 if so==1
replace region=2 if ne==1
replace region=3 if mw==1
replace region=4 if we==1


gen tenyear=.

local k=1880

local i=1889

local j=1

while `i' < 2000 {
replace tenyear=`j' if (year<=`i'&year>=`k')
local i = `i' + 10
local k = `k' + 10
local j = `j' + 1
}

sort state tenyear year
egen dec=min(year), by(state tenyear)

collapse (mean) compnorm, by(region dec)

reshape wide compnorm, i(dec) j(region)

rename compnorm1 so
rename compnorm2 ne
rename compnorm3 mw
rename compnorm4 we

label variable dec ""
label variable so "South"
label variable ne "North-East"
label variable mw "Mid-West"
label variable we "West"

****************
*** Figure 1 ***
****************

# delimit ;
scatter so ne mw we dec, title("Figure 1 - Political Competition by Decades", margin(medsmall) size(medium))
ytitle("Political Competition", margin(small) size(medsmall)) 
xtitle("Decades", margin(small) size(medsmall))
xlabel(1880 "1880s" 1900 "1900s" 1920 "1920s" 
1940 "1940s" 1960 "1960s" 1980 "1980s")
msymbol(triangle_hollow X plus circle_hollow) msize(medium medium medium medium) mcolor(black black black black)
connect(l l l l)
note("Note: Each observation is a ten year average of our main measure of political competition" 
"which ranges from -0.5 to 0 with larger values indicating more competition. See the main"
"text for further details.", size(small));

# delimit cr

graph export results\Figure1.eps, replace as(eps)

exit




