*Table I:  Testing Potential Instruments

drop _all
clear mata
set memory 300000
set matsize 2000
use USKLEMS, clear
sort Year
merge Year using Instruments
tab _m
drop if _m == 2
drop _m
drop if YYDif == .
save aa, replace

**********************************************************************

*Table I - 1st stage p-values

use aa, clear
quietly tab Industry, gen(I)
global k = r(r)
foreach j in lnURateDif lnMExpDif lnMetalsPriceDif lnOilPriceDif SW1 SW2 SW3 SW4 SW5 SW6 SW7 SW8 SW9 SW10 SW11 SW12 SW13 SW14 SW15 {
	forvalues k = 1/$k {
		quietly generate `j'I`k' = `j'*I`k'
		}
	}
quietly tab Year, gen(Y)
global kk = r(r)
matrix R = J(18,2,0)
local k = 0
foreach j in lnMExpDif lnMetalsPriceDif lnOilPriceDif SW1 SW2 SW3 SW4 SW5 SW6 SW7 SW8 SW9 SW10 SW11 SW12 SW13 SW14 SW15 {
	local k = `k' + 1
	quietly regress XXDif I2-I$k Y2-Y$kk lnURateDifI2-lnURateDifI$k `j'I2-`j'I$k
	quietly testparm `j'*
	matrix R[`k',1] = r(p), e(N)
	}
matrix list R

*Horserace Ramey vs. spending changes (text)
quietly regress XXDif I2-I$k Y2-Y$kk lnURateDifI2-lnURateDifI$k SW13I2-SW13I$k lnMExpDifI2-lnMExpDifI$k
testparm SW13I*
testparm lnMExpDifI*

************************************************************************

*Table II

*OLS

use aa, clear
quietly tab Industry, gen(I)
global k = r(r)
forvalues k = 1/$k {
	quietly generate lnURateDifI`k' = lnURateDif*I`k'
	}
forvalues k = 1/$k {
	quietly generate lnCapUDifI`k' = lnCapUDif*I`k'
	}
quietly tab Year, gen(Y)
global kk = r(r)
regress YYDif XXDif I2-I$k Y2-Y$kk lnURateDifI2-lnURateDifI$k 
regress YYDif XXDif I2-I$k Y2-Y$kk 
regress YYDif XXDif I2-I$k Y2-Y$kk lnCapUDifI2-lnCapUDifI$k 
regress YYDif XXDif I2-I$k Y2-Y$kk lnCapUDifI2-lnCapUDifI$k lnURateDifI2-lnURateDifI$k 
regress YYDif XXDif I1-I$k lnURateDifI1-lnURateDifI$k 
matrix R = J(60,2,0)
forvalues i = 1/60 {
	quietly regress YYDif XXDif I1-I$k Y1-Y$kk lnURateDifI* if Industry ~= `i'
	matrix B = e(b)
	matrix V = e(V)
	matrix R[`i',1] = B[1,1], sqrt(V[1,1])
	}
drop _all
svmat double R
sort R1
list if _n == 1
list if _n == 60

*Baseline IV
matrix R = J(4,4,0)
local i = 0
foreach m in lnMExpDif lnMetalsPriceDif SW1 SW7 {
		local i = `i' + 1
		use aa, clear
		quietly drop if `m' == .
		quietly tab Industry, gen(I)
		global k = r(r)
		foreach j in lnURateDif `m' {
			forvalues k = 1/$k {
				quietly generate `j'I`k' = `j'*I`k'
				}
			}
		quietly tab Year, gen(Y)
		global kk = r(r)
		quietly regress XXDif I2-I$k Y2-Y$kk lnURateDifI2-lnURateDifI$k `m'I2-`m'I$k
		quietly testparm `m'*
		matrix R[`i',1] = r(p)
		quietly ivregress 2sls YYDif I2-I$k Y2-Y$kk lnURateDifI2-lnURateDifI$k (XXDif = `m'I2-`m'I$k)
		matrix B = e(b)
		matrix V = e(V)
		quietly estat overid
		matrix R[`i',2] = r(p_basmann), B[1,1], sqrt(V[1,1])
	}
matrix list R

*No URate controls
matrix R = J(4,4,0)
local i = 0
foreach m in lnMExpDif lnMetalsPriceDif SW1 SW7 {
		local i = `i' + 1
		use aa, clear
		quietly drop if `m' == .
		quietly tab Industry, gen(I)
		global k = r(r)
		foreach j in `m' {
			forvalues k = 1/$k {
				quietly generate `j'I`k' = `j'*I`k'
				}
			}
		quietly tab Year, gen(Y)
		global kk = r(r)
		quietly regress XXDif I2-I$k Y2-Y$kk `m'I2-`m'I$k
		quietly testparm `m'*
		matrix R[`i',1] = r(p)
		quietly ivregress 2sls YYDif I2-I$k Y2-Y$kk (XXDif = `m'I2-`m'I$k)
		matrix B = e(b)
		matrix V = e(V)
		quietly estat overid
		matrix R[`i',2] = r(p_basmann), B[1,1], sqrt(V[1,1])
	}
matrix list R

*Substitute Fed Cap Utilization
matrix R = J(4,4,0)
local i = 0
foreach m in lnMExpDif lnMetalsPriceDif SW1 SW7 {
		local i = `i' + 1
		use aa, clear
		quietly drop if `m' == .
		quietly tab Industry, gen(I)
		global k = r(r)
		foreach j in lnCapUDif `m' {
			forvalues k = 1/$k {
				quietly generate `j'I`k' = `j'*I`k'
				}
			}
		quietly tab Year, gen(Y)
		global kk = r(r)
		quietly regress XXDif I2-I$k Y2-Y$kk lnCapUDifI2-lnCapUDifI$k `m'I2-`m'I$k
		quietly testparm `m'*
		matrix R[`i',1] = r(p)
		quietly ivregress 2sls YYDif I2-I$k Y2-Y$kk lnCapUDifI2-lnCapUDifI$k (XXDif = `m'I2-`m'I$k)
		matrix B = e(b)
		matrix V = e(V)
		quietly estat overid
		matrix R[`i',2] = r(p_basmann), B[1,1], sqrt(V[1,1])
	}
matrix list R

*Add Fed Cap Utilization
matrix R = J(4,4,0)
local i = 0
foreach m in lnMExpDif lnMetalsPriceDif SW1 SW7 {
		local i = `i' + 1
		use aa, clear
		quietly drop if `m' == .
		quietly tab Industry, gen(I)
		global k = r(r)
		foreach j in lnCapUDif lnURateDif `m' {
			forvalues k = 1/$k {
				quietly generate `j'I`k' = `j'*I`k'
				}
			}
		quietly tab Year, gen(Y)
		global kk = r(r)
		quietly regress XXDif I2-I$k Y2-Y$kk lnCapUDifI2-lnCapUDifI$k lnURateDifI2-lnURateDifI$k `m'I2-`m'I$k
		quietly testparm `m'*
		matrix R[`i',1] = r(p)
		quietly ivregress 2sls YYDif I2-I$k Y2-Y$kk lnCapUDifI2-lnCapUDifI$k lnURateDifI2-lnURateDifI$k (XXDif = `m'I2-`m'I$k)
		matrix B = e(b)
		matrix V = e(V)
		quietly estat overid
		matrix R[`i',2] = r(p_basmann), B[1,1], sqrt(V[1,1])
	}
matrix list R

*No Year Dummies
matrix R = J(4,4,0)
local i = 0
foreach m in lnMExpDif lnMetalsPriceDif SW1 SW7 {
		local i = `i' + 1
		use aa, clear
		quietly drop if `m' == .
		quietly tab Industry, gen(I)
		global k = r(r)
		foreach j in lnURateDif `m' {
			forvalues k = 1/$k {
				quietly generate `j'I`k' = `j'*I`k'
				}
			}
		quietly tab Year, gen(Y)
		global kk = r(r)
		quietly regress XXDif I2-I$k lnURateDifI1-lnURateDifI$k `m'I1-`m'I$k
		quietly testparm `m'*
		matrix R[`i',1] = r(p)
		quietly ivregress 2sls YYDif I2-I$k lnURateDifI1-lnURateDifI$k (XXDif = `m'I1-`m'I$k)
		matrix B = e(b)
		matrix V = e(V)
		quietly estat overid
		matrix R[`i',2] = r(p_basmann), B[1,1], sqrt(V[1,1])
	}
matrix list R

*Dropping 1 industry at a time

foreach m in lnMExpDif lnMetalsPriceDif SW1 SW7 {
	matrix R = J(60,4,0)
	forvalues i = 1/60 {
		use aa, clear
		quietly drop if `m' == .
		quietly drop if Industry == `i'
		quietly tab Industry, gen(I)
		global k = r(r)
		foreach j in lnURateDif `m' {
			forvalues k = 1/$k {
				quietly generate `j'I`k' = `j'*I`k'
				}
			}
		quietly tab Year, gen(Y)
		global kk = r(r)
		quietly regress XXDif I2-I$k Y2-Y$kk lnURateDifI2-lnURateDifI$k `m'I2-`m'I$k
		quietly testparm `m'*
		matrix R[`i',1] = r(p)
		quietly ivregress 2sls YYDif I2-I$k Y2-Y$kk lnURateDifI2-lnURateDifI$k (XXDif = `m'I2-`m'I$k)
		matrix B = e(b)
		matrix V = e(V)
		quietly estat overid
		matrix R[`i',2] = r(p_basmann), B[1,1], sqrt(V[1,1])
		}
	drop _all
	svmat double R
	save R`m', replace
	sum
	sort R3
	list if _n == 1
	list if _n == 60
	}

*Dropping 2 industries at a time (defense)
use aa, clear
keep Industry Year lnURateDif lnMExpDif YYDif XXDif
sort Industry Year
save aaa, replace

matrix RR = J(1770,6,0)
foreach m in lnMExpDif {
	local i = 0
	forvalues a = 1/60 {
		global a = `a' + 1
		forvalues b = $a/60 {
			display `a', `b'
			local i = `i' + 1
			use aaa, clear
			quietly drop if Industry == `a'
			quietly drop if Industry == `b'
			quietly tab Industry, gen(I)
			global k = r(r)
			foreach j in lnURateDif `m' {
				forvalues k = 1/$k {
					quietly generate `j'I`k' = `j'*I`k'
					}
				}
			quietly tab Year, gen(Y)
			global kk = r(r)
			quietly regress XXDif I2-I$k Y2-Y$kk lnURateDifI2-lnURateDifI$k `m'I2-`m'I$k
			quietly testparm `m'*
			matrix RR[`i',1] = r(p)
			quietly ivregress 2sls YYDif I2-I$k Y2-Y$kk lnURateDifI2-lnURateDifI$k (XXDif = `m'I2-`m'I$k)
			matrix B = e(b)
			matrix V = e(V)
			quietly estat overid
			matrix RR[`i',2] = r(p_basmann), B[1,1], sqrt(V[1,1]), `a', `b'
			}
		}
	drop _all
	svmat double RR
	save RR`m', replace
	sum
	sort RR3
	list if _n == 1
	list if _n == _N
	}

*Dropping 3 industries at a time (defense)
foreach m in lnMExpDif {
	forvalues a = 1/58 {
		local i = 0
		matrix RR = J(1770,7,0)
		global a = `a' + 1
		forvalues b = $a/59 {
			global b = `b' + 1
				forvalues c = $b/60 {
					display `a', `b', `c'
					local i = `i' + 1
					use aaa, clear
					quietly drop if Industry == `a'
					quietly drop if Industry == `b'
					quietly drop if Industry == `c'
					quietly tab Industry, gen(I)
					global k = r(r)
					foreach j in lnURateDif `m' {
						forvalues k = 1/$k {
							quietly generate `j'I`k' = `j'*I`k'
							}
						}
					quietly tab Year, gen(Y)
					global kk = r(r)
					quietly regress XXDif I2-I$k Y2-Y$kk lnURateDifI2-lnURateDifI$k `m'I2-`m'I$k
					quietly testparm `m'*
					matrix RR[`i',1] = r(p)
					quietly ivregress 2sls YYDif I2-I$k Y2-Y$kk lnURateDifI2-lnURateDifI$k (XXDif = `m'I2-`m'I$k)
					matrix B = e(b)
					matrix V = e(V)
					quietly estat overid
					matrix RR[`i',2] = r(p_basmann), B[1,1], sqrt(V[1,1]), `a', `b', `c'
					}
				}
		drop _all
		svmat double RR
		save RR`a', replace
		}
	}

drop _all
use RR1, clear
forvalues i = 2/58 {
	append using RR`i'
	}
drop if RR1 == 0
sort RR5 RR6 RR7
save RRRlnMExpDif, replace
sum
sort RR3
list if _n == _N

*Lags

forvalues c = 1/4 {
	matrix R = J(4,4,0)
	local i = 0
	foreach m in lnMExpDif lnMetalsPriceDif SW1 SW7 {
		local i = `i' + 1
		use aa, clear
		quietly drop if `m' == .
		sort Industry Year
		forvalues k = 1/4 {
			quietly generate L`k'XXDif = XXDif[_n-`k'] if Industry == Industry[_n-`k'] & Year == Year[_n-`k'] + `k'
			}
		quietly tab Industry, gen(I)
		global k = r(r)
		foreach j in lnURateDif `m' {
			forvalues k = 1/$k {
				quietly generate `j'I`k' = `j'*I`k'
				}
			}
		quietly tab Year, gen(Y)
		global kk = r(r)
		quietly regress XXDif L1XXDif-L`c'XXDif I2-I$k Y2-Y$kk lnURateDifI2-lnURateDifI$k `m'I2-`m'I$k 
		quietly testparm `m'I*
		matrix R[`i',1] = r(p)		
		quietly ivregress 2sls YYDif L1XXDif-L`c'XXDif I2-I$k Y2-Y$kk lnURateDifI2-lnURateDifI$k (XXDif = `m'I2-`m'I$k)
		quietly estat overid
		matrix B = e(b)
		matrix V = e(V)
		matrix C = B[1,1..1+`c']*J(1+`c',1,1)
		matrix CC = J(1,1+`c',1)*V[1..1+`c',1..1+`c']*J(1+`c',1,1)
		matrix CCC = C[1,1], sqrt(CC[1,1])
		matrix R[`i',2] = r(p_basmann), CCC
		}
	matrix list R
	}

*OLS w/ lags
matrix R = J(4,2,0)
use aa, clear
sort Industry Year
forvalues k = 1/4 {
	quietly generate L`k'XXDif = XXDif[_n-`k'] if Industry == Industry[_n-`k'] & Year == Year[_n-`k'] + `k'
	}
quietly tab Industry, gen(I)
global k = r(r)
foreach j in lnURateDif {
	forvalues k = 1/$k {
		quietly generate `j'I`k' = `j'*I`k'
		}
	}
quietly tab Year, gen(Y)
global kk = r(r)

forvalues c = 1/4 {
	quietly regress YYDif XXDif L1XXDif-L`c'XXDif I2-I$k Y2-Y$kk lnURateDifI2-lnURateDifI$k 
	matrix B = e(b)
	matrix V = e(V)
	matrix C = B[1,1..1+`c']*J(1+`c',1,1)
	matrix CC = J(1,1+`c',1)*V[1..1+`c',1..1+`c']*J(1+`c',1,1)
	matrix R[`c',1] = C, sqrt(CC[1,1])
	}
matrix list R


**********************************************************************************

*Table II - associated text 

*1st stage correlation of coefficients of energy instrument with energy intensity

use aa, clear
quietly drop if SW1 == .
quietly tab Industry, gen(I)
global k = r(r)
foreach j in lnURateDif SW1 {
	forvalues k = 1/$k {
		quietly generate `j'I`k' = `j'*I`k'
		}
	}
quietly tab Year, gen(Y)
global kk = r(r)
quietly regress XXDif SW1I2-SW1I$k I2-I$k Y2-Y$kk lnURateDifI2-lnURateDifI$k 
matrix B = e(b)
matrix B = B[1,1..59]'
use USKLEMS, clear
tab Year if EI ~= .
keep if Year >= 1997
quietly replace EI = EI/PQ
collapse (mean) EI, by(Industry) fast
quietly drop if Industry == 1
quietly svmat double B
pwcorr, sig

*Capacity Utilization and Aggregate Unemployment

use aa, clear
quietly drop if lnMExpDif == .
quietly tab Industry, gen(I)
global k = r(r)
foreach j in lnCapUDif lnURateDif lnMExpDif {
	forvalues k = 1/$k {
		quietly generate `j'I`k' = `j'*I`k'
		}
	}
quietly tab Year, gen(Y)
global kk = r(r)
quietly regress XXDif I2-I$k Y2-Y$kk lnCapUDifI2-lnCapUDifI$k lnURateDifI2-lnURateDifI$k lnMExpDifI2-lnMExpDifI$k
testparm lnURateDifI*
quietly ivregress 2sls YYDif I2-I$k Y2-Y$kk lnCapUDifI2-lnCapUDifI$k lnURateDifI2-lnURateDifI$k (XXDif = lnMExpDifI2-lnMExpDifI$k)
testparm lnURateDifI*

*Correlation of defense spending instrument with changes in unemployment rates during sample period

use USKLEMS, clear
sum Year if YYDif ~= .
use Instruments, clear
pwcorr lnMExpDif lnURateDif if Year >= 1988 & Year <= 2010, sig

*OLS: TFP growth and output growth

matrix R = J(5,2,0)
use aa, clear
sort Industry Year
forvalues k = 1/4 {
	quietly generate L`k'QDif = QDif[_n-`k'] if Industry == Industry[_n-`k'] & Year == Year[_n-`k'] + `k'
	}
quietly tab Industry, gen(I)
global k = r(r)
forvalues k = 1/$k {
	quietly generate lnURateDifI`k' = lnURateDif*I`k'
	}
quietly tab Year, gen(Y)
global kk = r(r)
quietly regress YYDif QDif I2-I$k Y2-Y$kk lnURateDifI2-lnURateDifI$k 
matrix B = e(b)
matrix V = e(V)
matrix R[1,1] = B[1,1], sqrt(V[1,1])
forvalues c = 1/4 {
	quietly regress YYDif QDif L1QDif-L`c'QDif I2-I$k Y2-Y$kk lnURateDifI2-lnURateDifI$k 
	matrix B = e(b)
	matrix V = e(V)
	matrix C = B[1,1..1+`c']*J(1+`c',1,1)
	matrix CC = J(1,1+`c',1)*V[1..1+`c',1..1+`c']*J(1+`c',1,1)
	matrix R[`c'+1,1] = C, sqrt(CC[1,1])
	}
matrix list R

*Montecarlo Simulations - checking distribution of overidentification X2 tests with covariance matrix suggested (suggested, not estimated) by baseline specification

use aa, clear
quietly tab Industry, gen(I)
global k = r(r)
foreach j in lnURateDif lnMExpDif {
	forvalues k = 2/$k {
		quietly generate `j'I`k' = `j'*I`k'
		}
	}
quietly tab Year, gen(Y)
global kk = r(r)
keep YYDif XXDif I2-I$k Y2-Y$kk lnURateDifI2-lnURateDifI$k lnMExpDifI2-lnMExpDifI$k
quietly ivregress 2sls YYDif I2-I$k Y2-Y$kk lnURateDifI2-lnURateDifI$k (XXDif = lnMExpDifI2-lnMExpDifI$k)
matrix B = e(b)
quietly predict double YYhat
quietly generate double YError = YYDif - YYhat
quietly regress XXDif I2-I$k Y2-Y$kk lnURateDifI2-lnURateDifI$k lnMExpDifI2-lnMExpDifI$k
quietly predict double XXhat
quietly generate double XError = XXDif - XXhat
corr YError XError, cov
matrix V = r(C)
*Degrees of freedom correction
matrix V = V*1379/1180
matrix T = cholesky(V)
quietly replace YYhat = YYhat - B[1,1]*XXDif
quietly generate double X1 = 0
quietly generate double X2 = 0
save aaa, replace

forvalues j = 1/500 {
	use aaa, clear
	matrix R = J(1000,3,0)
	forvalues i = 1/1000 {
		local k = (`j'-1)*1000 + `i'
		set seed `k'
		quietly replace X1 = invnormal(uniform())
		quietly replace X2 = invnormal(uniform())
		quietly replace XXDif = XXhat + T[2,1]*X1 + T[2,2]*X2
		quietly replace YYDif = YYhat + B[1,1]*XXDif + T[1,1]*X1
		quietly ivregress 2sls YYDif I2-I$k Y2-Y$kk lnURateDifI2-lnURateDifI$k (XXDif = lnMExpDifI2-lnMExpDifI$k)
		quietly estat overid
		matrix R[`i',1] = r(p_sargan), r(p_basmann), `k'
		display `k'
		}
	drop _all
	svmat double R
	save R`j', replace
	}

use R1, clear
capture erase R1.dta
forvalues j = 2/500 {
	append using R`j'
	capture erase R`j'.dta
	}
save SarganBasmannSimulation, replace

sum
matrix R = J(1,4,0)
count if R1 < .05
matrix R[1,1] = r(N)
count if R1 < .01
matrix R[1,2] = r(N)
count if R2 < .05
matrix R[1,3] = r(N)
count if R2 < .01
matrix R[1,4] = r(N)
matrix R = R/500000
matrix list R

***********************************************************

*Figure IV

matrix R = J(59,4,0)
use aa, clear
quietly tab Industry, gen(I)
global k = r(r)
foreach j in lnURateDif lnMExpDif {
	forvalues k = 1/$k {
		quietly generate `j'I`k' = `j'*I`k'
		}
	}
quietly tab Year, gen(Y)
global kk = r(r)
quietly regress XXDif lnMExpDifI2-lnMExpDifI$k I2-I$k Y2-Y$kk lnURateDifI2-lnURateDifI$k 
matrix B = e(b)
matrix V = e(V)
matrix R[1,1] = B[1,1..59]'
matrix R[1,2] = sqrt(V[1,1])
quietly regress QDif lnMExpDifI2-lnMExpDifI$k I2-I$k Y2-Y$kk lnURateDifI2-lnURateDifI$k 
matrix B = e(b)
matrix V = e(V)
matrix R[1,3] = B[1,1..59]'
matrix R[1,4] = sqrt(V[1,1])
drop _all
svmat double R
*R1 & R3 used to make figure
*Comment on correlation in text
pwcorr R1 R3, sig obs
pwcorr R1 R3 if abs(R1) < .2, sig obs
quietly replace R2 = R2[_n-1] if _n > 1
quietly replace R4 = R4[_n-1] if _n > 1
*Comment on tstats in footnote
quietly generate double tstatEmp = abs(R1/R2)
quietly generate double tstatOut = abs(R3/R4)
sum tstat*

*******************************************************************

*Table III

drop _all
clear mata
set memory 300000
set matsize 2000
use USKLEMS, clear
sort Year
merge Year using Instruments
tab _m
drop if _m == 2
drop _m
sort Industry Year
merge Industry Year using CapUtilization
tab _m
keep if _m == 3
sort Industry Year
drop if YYDif == .

quietly tab Industry, gen(I)
global k = r(r)
foreach m in lnURateDif lnMExpDif SW13 {
	forvalues k = 1/$k {
		quietly generate `m'I`k' = `m'*I`k'
		}
	}
quietly tab Year, gen(Y)
global kk = r(r)
quietly sort Industry Year
foreach m in XXDif QDif {
	forvalues k = 1/4 {
		generate L`k'`m' = `m'[_n-`k'] if Industry == Industry[_n-`k'] & Year == Year[_n-`k'] + `k'
		}
	}


*Horserace Ramey vs actual expenditures
quietly regress QDif I2-I$k Y2-Y$kk lnURateDifI* SW13I*
testparm SW13I*
quietly regress XXDif I2-I$k Y2-Y$kk lnURateDifI* SW13I*
testparm SW13I*
quietly regress QDif I2-I$k Y2-Y$kk lnURateDifI* SW13I* lnMExpDifI*
testparm SW13I*
testparm lnMExpDifI*
quietly regress XXDif I2-I$k Y2-Y$kk lnURateDifI* SW13I* lnMExpDifI*
testparm SW13I*
testparm lnMExpDifI*

matrix R = J(4,6,0)
local i = 0
foreach m in QDif XXDif {
	local i = `i' + 1
	quietly regress lnCapUIDif `m' I2-I$k Y2-Y$kk lnURateDifI*
	matrix B = e(b)
	matrix V = e(V)
	matrix R[`i',1] = B[1,1], sqrt(V[1,1]), e(N)
	quietly regress lnCapUIDif `m' L1`m'-L4`m' I2-I$k Y2-Y$kk lnURateDifI*
	matrix B = e(b)
	matrix V = e(V)
	matrix C = B[1,1..5]*J(5,1,1)
	matrix CC = J(1,5,1)*V[1..5,1..5]*J(5,1,1)
	matrix R[`i',4] = C[1,1], sqrt(CC[1,1]), e(N)

	local i = `i' + 1
	quietly regress YYDif `m' I2-I$k Y2-Y$kk lnURateDifI*
	matrix B = e(b)
	matrix V = e(V)
	matrix R[`i',1] = B[1,1], sqrt(V[1,1]), e(N)
	quietly regress YYDif `m' L1`m'-L4`m' I2-I$k Y2-Y$kk lnURateDifI*
	matrix B = e(b)
	matrix V = e(V)
	matrix C = B[1,1..5]*J(5,1,1)
	matrix CC = J(1,5,1)*V[1..5,1..5]*J(5,1,1)
	matrix R[`i',4] = C[1,1], sqrt(CC[1,1]), e(N)
	}
matrix list R

matrix RR = J(8,5,0)
local i = 0
foreach m in QDif XXDif {
	local i = `i' + 1
	quietly regress `m' I2-I$k Y2-Y$kk lnURateDifI* lnMExpDifI*
	quietly testparm lnMExpDifI*
	matrix RR[`i',1] = r(p)
	quietly ivregress 2sls lnCapUIDif I2-I$k Y2-Y$kk lnURateDifI* (`m' = lnMExpDifI*)
	matrix B = e(b)
	matrix V = e(V)
	quietly estat overid
	matrix RR[`i',2] = r(p_basmann), B[1,1], sqrt(V[1,1]), e(N)

	local i = `i' + 1
	quietly regress `m' L1`m'-L4`m' I2-I$k Y2-Y$kk lnURateDifI* lnMExpDifI*
	quietly testparm lnMExpDifI*
	matrix RR[`i',1] = r(p)
	quietly ivregress 2sls lnCapUIDif L1`m'-L4`m' I2-I$k Y2-Y$kk lnURateDifI* (`m' = lnMExpDifI*)
	matrix B = e(b)
	matrix V = e(V)
	matrix C = B[1,1..5]*J(5,1,1)
	matrix CC = J(1,5,1)*V[1..5,1..5]*J(5,1,1)
	quietly estat overid
	matrix RR[`i',2] = r(p_basmann), C[1,1], sqrt(CC[1,1]), e(N)

	local i = `i' + 1
	quietly regress `m' I2-I$k Y2-Y$kk lnURateDifI* lnMExpDifI*
	quietly testparm lnMExpDifI*
	matrix RR[`i',1] = r(p)
	quietly ivregress 2sls YYDif I2-I$k Y2-Y$kk lnURateDifI* (`m' = lnMExpDifI*)
	matrix B = e(b)
	matrix V = e(V)
	quietly estat overid
	matrix RR[`i',2] = r(p_basmann), B[1,1], sqrt(V[1,1]), e(N)

	local i = `i' + 1
	quietly regress `m' L1`m'-L4`m' I2-I$k Y2-Y$kk lnURateDifI* lnMExpDifI*
	quietly testparm lnMExpDifI*
	matrix RR[`i',1] = r(p)
	quietly ivregress 2sls YYDif L1`m'-L4`m' I2-I$k Y2-Y$kk lnURateDifI* (`m' = lnMExpDifI*)
	matrix B = e(b)
	matrix V = e(V)
	matrix C = B[1,1..5]*J(5,1,1)
	matrix CC = J(1,5,1)*V[1..5,1..5]*J(5,1,1)
	quietly estat overid
	matrix RR[`i',2] = r(p_basmann), C[1,1], sqrt(CC[1,1]), e(N)
	}
matrix list RR


********************************************************************

*Key results using original BLS TFP estimates & gross labour allocations (footnote at end of US KLEMS analysis)

*Table II - defense expenditures as the instrument

use aa, clear
sort Industry Year
forvalues k = 1/4 {
	quietly generate L`k'XDif = XDif[_n-`k'] if Industry == Industry[_n-`k'] & Year == Year[_n-`k'] + `k'
	}
quietly tab Industry, gen(I)
global k = r(r)
foreach j in lnURateDif lnMExpDif lnCapUDif {
	forvalues k = 1/$k {
		quietly generate `j'I`k' = `j'*I`k'
		}
	}
quietly tab Year, gen(Y)
global kk = r(r)

matrix R = J(6,4,0)
quietly regress XDif I2-I$k Y2-Y$kk lnURateDifI2-lnURateDifI$k lnMExpDifI2-lnMExpDifI$k
quietly testparm lnMExpDifI*
matrix R[1,1] = r(p)		
quietly ivregress 2sls YDif I2-I$k Y2-Y$kk lnURateDifI2-lnURateDifI$k (XDif = lnMExpDifI2-lnMExpDifI$k)
quietly estat overid
matrix B = e(b)
matrix V = e(V)
matrix R[1,2] = r(p_basmann), B[1,1], sqrt(V[1,1])

quietly regress XDif I2-I$k Y2-Y$kk lnMExpDifI2-lnMExpDifI$k
quietly testparm lnMExpDifI*
matrix R[2,1] = r(p)		
quietly ivregress 2sls YDif I2-I$k Y2-Y$kk (XDif = lnMExpDifI2-lnMExpDifI$k)
quietly estat overid
matrix B = e(b)
matrix V = e(V)
matrix R[2,2] = r(p_basmann), B[1,1], sqrt(V[1,1])

quietly regress XDif I2-I$k Y2-Y$kk lnCapUDifI2-lnCapUDifI$k lnMExpDifI2-lnMExpDifI$k
quietly testparm lnMExpDifI*
matrix R[3,1] = r(p)		
quietly ivregress 2sls YDif I2-I$k Y2-Y$kk lnCapUDifI2-lnCapUDifI$k (XDif = lnMExpDifI2-lnMExpDifI$k)
quietly estat overid
matrix B = e(b)
matrix V = e(V)
matrix R[3,2] = r(p_basmann), B[1,1], sqrt(V[1,1])

quietly regress XDif I2-I$k Y2-Y$kk lnCapUDifI2-lnCapUDifI$k lnURateDifI2-lnURateDifI$k lnMExpDifI2-lnMExpDifI$k
quietly testparm lnMExpDifI*
matrix R[4,1] = r(p)		
quietly ivregress 2sls YDif I2-I$k Y2-Y$kk lnCapUDifI2-lnCapUDifI$k lnURateDifI2-lnURateDifI$k (XDif = lnMExpDifI2-lnMExpDifI$k)
quietly estat overid
matrix B = e(b)
matrix V = e(V)
matrix R[4,2] = r(p_basmann), B[1,1], sqrt(V[1,1])

quietly regress XDif I2-I$k lnURateDifI1-lnURateDifI$k lnMExpDifI1-lnMExpDifI$k
quietly testparm lnMExpDifI*
matrix R[5,1] = r(p)		
quietly ivregress 2sls YDif I2-I$k lnURateDifI1-lnURateDifI$k (XDif = lnMExpDifI1-lnMExpDifI$k)
quietly estat overid
matrix B = e(b)
matrix V = e(V)
matrix R[5,2] = r(p_basmann), B[1,1], sqrt(V[1,1])

quietly regress XDif L1XDif-L4XDif I2-I$k Y2-Y$kk lnURateDifI2-lnURateDifI$k lnMExpDifI2-lnMExpDifI$k
quietly testparm lnMExpDifI*
matrix R[6,1] = r(p)	
quietly ivregress 2sls YDif L1XDif-L4XDif I2-I$k Y2-Y$kk lnURateDifI2-lnURateDifI$k (XDif = lnMExpDifI2-lnMExpDifI$k)
quietly estat overid
matrix B = e(b)
matrix V = e(V)
matrix C = B[1,1..5]*J(5,1,1)
matrix CC = J(1,5,1)*V[1..5,1..5]*J(5,1,1)
matrix R[6,2] = r(p_basmann), C[1,1], sqrt(CC[1,1])
matrix list R

*Table II: OLS

matrix RR = J(2,2,0)
quietly regress YDif XDif I2-I$k Y2-Y$kk lnURateDifI2-lnURateDifI$k 
matrix B = e(b)
matrix V = e(V)
matrix RR[1,1] = B[1,1], sqrt(V[1,1])
quietly regress YDif XDif L1XDif-L4XDif I2-I$k Y2-Y$kk lnURateDifI2-lnURateDifI$k
matrix B = e(b)
matrix V = e(V)
matrix C = B[1,1..5]*J(5,1,1)
matrix CC = J(1,5,1)*V[1..5,1..5]*J(5,1,1)
matrix RR[2,1] = C[1,1], sqrt(CC[1,1])
matrix list RR

*Table III

drop _all
clear mata
set memory 300000
set matsize 2000
use USKLEMS, clear
sort Year
merge Year using Instruments
tab _m
drop if _m == 2
drop _m
sort Industry Year
merge Industry Year using CapUtilization
tab _m
keep if _m == 3
sort Industry Year
drop if YDif == .

quietly tab Industry, gen(I)
global k = r(r)
foreach m in lnURateDif lnMExpDif {
	forvalues k = 1/$k {
		quietly generate `m'I`k' = `m'*I`k'
		}
	}
quietly tab Year, gen(Y)
global kk = r(r)
sort Industry Year
foreach m in XDif {
	forvalues k = 1/4 {
		generate L`k'`m' = `m'[_n-`k'] if Industry == Industry[_n-`k'] & Year == Year[_n-`k'] + `k'
		}
	}

matrix RR = J(4,5,0)
quietly regress XDif I2-I$k Y2-Y$kk lnURateDifI* lnMExpDifI*
quietly testparm lnMExpDifI*
matrix RR[1,1] = r(p)
quietly ivregress 2sls lnCapUIDif I2-I$k Y2-Y$kk lnURateDifI* (XDif = lnMExpDifI*)
matrix B = e(b)
matrix V = e(V)
quietly estat overid
matrix RR[1,2] = r(p_basmann), B[1,1], sqrt(V[1,1]), e(N)

quietly regress XDif L1XDif-L4XDif I2-I$k Y2-Y$kk lnURateDifI* lnMExpDifI*
quietly testparm lnMExpDifI*
matrix RR[2,1] = r(p)
quietly ivregress 2sls lnCapUIDif L1XDif-L4XDif I2-I$k Y2-Y$kk lnURateDifI* (XDif = lnMExpDifI*)
matrix B = e(b)
matrix V = e(V)
matrix C = B[1,1..5]*J(5,1,1)
matrix CC = J(1,5,1)*V[1..5,1..5]*J(5,1,1)
quietly estat overid
matrix RR[2,2] = r(p_basmann), C[1,1], sqrt(CC[1,1]), e(N)

quietly regress XDif I2-I$k Y2-Y$kk lnURateDifI* lnMExpDifI*
quietly testparm lnMExpDifI*
matrix RR[3,1] = r(p)
quietly ivregress 2sls YDif I2-I$k Y2-Y$kk lnURateDifI* (XDif = lnMExpDifI*)
matrix B = e(b)
matrix V = e(V)
quietly estat overid
matrix RR[3,2] = r(p_basmann), B[1,1], sqrt(V[1,1]), e(N)

quietly regress XDif L1XDif-L4XDif I2-I$k Y2-Y$kk lnURateDifI* lnMExpDifI*
quietly testparm lnMExpDifI*
matrix RR[4,1] = r(p)
quietly ivregress 2sls YDif L1XDif-L4XDif I2-I$k Y2-Y$kk lnURateDifI* (XDif = lnMExpDifI*)
matrix B = e(b)
matrix V = e(V)
matrix C = B[1,1..5]*J(5,1,1)
matrix CC = J(1,5,1)*V[1..5,1..5]*J(5,1,1)
quietly estat overid
matrix RR[4,2] = r(p_basmann), C[1,1], sqrt(CC[1,1]), e(N)

matrix list RR


************************************************

*Table VIII:  Goods, services and total private sector productivity growth under various elasticities

matrix R = J(5,3,0)
forvalues i = 0/4 {
	global e = `i'*.25
	use USKLEMS, clear
	sort Industry Year
	quietly generate Goods = 1 if Industry <= 23
	quietly replace Goods = 1 if Industry == 25
	quietly replace Goods = 0 if Goods == .
	egen double m = sum(VA), by(Goods Year)
	egen double mm = sum(VA), by(Year)
	quietly replace m = PQ/m
	quietly replace mm = VA/mm
	quietly generate double mbar = (m + m[_n-1])/2 if Industry == Industry[_n-1] & Year == Year[_n-1] + 1
	quietly generate double mmbar = (mm + mm[_n-1])/2 if Industry == Industry[_n-1] & Year == Year[_n-1] + 1
	quietly generate double tfpg = (YYDif + $e*XXDif)*mbar
	quietly drop if tfpg == .
	collapse (sum) tfpg mmbar, by(Goods Year) fast
	quietly sum tfpg if Goods == 1
	matrix R[`i'+1,1] = r(mean)
	quietly sum tfpg if Goods == 0
	matrix R[`i'+1,2] = r(mean)
	quietly replace tfpg = tfpg*mmbar
	quietly collapse (sum) tfpg mmbar, by(Year) fast
	quietly sum tfpg
	matrix R[`i'+1,3] = r(mean)
	}
matrix list R


*Footnote on wages and factor shares
use USKLEMS, clear
quietly generate G = 1 if Industry <= 23
quietly replace G = 1 if Industry == 25
quietly replace G = 0 if G == .
collapse (sum) WL VA Hours, by(G Year) fast
quietly generate Wage = WL/Hours
quietly generate Theta = WL/VA
sort Year G
generate WDif = ln(Wage/Wage[_n-1]) if G == 1 & G[_n-1] == 0
generate TDif = ln(Theta/Theta[_n-1]) if G == 1 & G[_n-1] == 0
sort G Year
by G: sum WDif Theta
regress WDif Year
regress TDif Year


*Standard Productivity Calculations with and without my labour adjustments (footnote in text early Section II)
use USKLEMS, clear
sort Industry Year
egen double m = sum(VA), by(Year)
quietly replace m = PQ/m
quietly generate double mbar = (m + m[_n-1])/2 if Industry == Industry[_n-1] & Year == Year[_n-1] + 1
quietly replace YDif = YDif*mbar
quietly replace YYDif = YYDif*mbar
drop if YYDif == .
collapse (sum) YYDif YDif mbar, by(Year)
sum



